/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.thread;

import cn.aradin.spring.core.thread.handler.ThreadRejectHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GlobalThreadManager {
    public static final String DEFAULT_SINGLE_POOL_NAME = "DEFAULT_SINGLE_POOL_NAME";
    private static ThreadPoolProxy mLongPool = null;
    private static Object mLongLock = new Object();
    private static ThreadPoolProxy mShortPool = null;
    private static Object mShortLock = new Object();
    private static ThreadPoolProxy mDownloadPool = null;
    private static Object mDownloadLock = new Object();
    private static Map<String, ThreadPoolProxy> mMap = new HashMap<String, ThreadPoolProxy>();
    private static Object mSingleLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolProxy getDownloadPool() {
        if (mDownloadPool == null) {
            Object object = mDownloadLock;
            synchronized (object) {
                if (mDownloadPool == null) {
                    mDownloadPool = new ThreadPoolProxy(4, 10, 10000, 5L);
                }
                return mDownloadPool;
            }
        }
        return mDownloadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolProxy getLongPool() {
        if (mLongPool == null) {
            Object object = mLongLock;
            synchronized (object) {
                if (mLongPool == null) {
                    mLongPool = new ThreadPoolProxy(10, 30, 10000, 30L);
                }
                return mLongPool;
            }
        }
        return mLongPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolProxy getShortPool() {
        if (mShortPool == null) {
            Object object = mShortLock;
            synchronized (object) {
                if (mShortPool == null) {
                    mShortPool = new ThreadPoolProxy(8, 20, 100000, 15L);
                }
                return mShortPool;
            }
        }
        return mShortPool;
    }

    public static ThreadPoolProxy getSinglePool() {
        return GlobalThreadManager.getSinglePool(DEFAULT_SINGLE_POOL_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolProxy getSinglePool(String name) {
        Object object = mSingleLock;
        synchronized (object) {
            ThreadPoolProxy singlePool = mMap.get(name);
            if (singlePool == null) {
                singlePool = new ThreadPoolProxy(1, 1, 20000, 5L);
                mMap.put(name, singlePool);
            }
            return singlePool;
        }
    }

    public static class ThreadPoolProxy {
        private ThreadPoolExecutor mPool;
        private int mCorePoolSize;
        private int mMaximumPoolSize;
        private int queueSize;
        private long mKeepAliveTime;

        private ThreadPoolProxy(int corePoolSize, int maximumPoolSize, int queueSize, long keepAliveTime) {
            this.mCorePoolSize = corePoolSize;
            this.mMaximumPoolSize = maximumPoolSize;
            this.queueSize = queueSize;
            this.mKeepAliveTime = keepAliveTime;
        }

        public synchronized void execute(Runnable runn) {
            if (runn == null) {
                return;
            }
            if (this.mPool == null || this.mPool.isShutdown()) {
                this.mPool = new ThreadPoolExecutor(this.mCorePoolSize, this.mMaximumPoolSize, this.mKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize), Executors.defaultThreadFactory(), new ThreadRejectHandler());
            }
            this.mPool.submit(runn);
        }

        public synchronized <T> Future<T> execute(Callable<T> callable) {
            if (callable == null) {
                return null;
            }
            if (this.mPool == null || this.mPool.isShutdown()) {
                this.mPool = new ThreadPoolExecutor(this.mCorePoolSize, this.mMaximumPoolSize, this.mKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize), Executors.defaultThreadFactory(), new ThreadRejectHandler());
            }
            return this.mPool.submit(callable);
        }

        public synchronized void cancel(Runnable runn) {
            if (this.mPool != null && !this.mPool.isShutdown() || this.mPool.isTerminating()) {
                this.mPool.getQueue().remove(runn);
            }
        }

        public synchronized boolean contains(Runnable runn) {
            if (this.mPool != null && (!this.mPool.isShutdown() || this.mPool.isTerminating())) {
                return this.mPool.getQueue().contains(runn);
            }
            return false;
        }

        public void stop() {
            if (this.mPool != null && (!this.mPool.isShutdown() || this.mPool.isTerminating())) {
                this.mPool.shutdown();
            }
        }

        public synchronized void shutdown() {
            if (this.mPool != null && (!this.mPool.isShutdown() || this.mPool.isTerminating())) {
                this.mPool.shutdownNow();
            }
        }
    }
}

