/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine.manager;

import cn.aradin.spring.caffeine.cache.Caffeineson;
import cn.aradin.spring.caffeine.cache.config.CaffeinesonConfig;
import cn.aradin.spring.caffeine.manager.VersionCacheManager;
import cn.aradin.spring.caffeine.manager.properties.CaffeinesonProperties;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class CaffeinesonCacheManager
implements VersionCacheManager {
    private static final Logger log = LoggerFactory.getLogger(CaffeinesonCacheManager.class);
    ConcurrentHashMap<String, Long> versionMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Caffeineson> instanceMap = new ConcurrentHashMap();
    Map<String, CaffeinesonConfig> configs = new ConcurrentHashMap<String, CaffeinesonConfig>();
    CaffeinesonConfig defaultConfig = new CaffeinesonConfig();
    RemovalListener<Object, Object> listener;
    boolean versioned = false;
    IVersionBroadHandler versionBroadHandler;
    String versionGroup;

    public CaffeinesonCacheManager(CaffeinesonProperties caffeinesonProperties, RemovalListener<Object, Object> listener, IVersionBroadHandler versionBroadHandler) {
        this.configs = caffeinesonProperties.getConfigs();
        this.defaultConfig = caffeinesonProperties.getDefaults();
        this.listener = listener;
        this.versioned = caffeinesonProperties.isVersioned();
        this.versionBroadHandler = versionBroadHandler;
        this.versionGroup = caffeinesonProperties.getGroup();
    }

    protected CaffeinesonConfig createCaffeinesonConfig() {
        return this.defaultConfig;
    }

    protected Caffeineson buildCache(String name) {
        Caffeineson cache;
        long version = this.version(name);
        String exact_name = version + "##" + name;
        Caffeineson oldCache = this.instanceMap.putIfAbsent(exact_name, cache = new Caffeineson(name, this.versionGroup, this.versioned, this.configs.get(name), this.listener, this.versionBroadHandler));
        if (oldCache != null) {
            cache = oldCache;
        }
        return cache;
    }

    public Cache getCache(String name) {
        long version = this.version(name);
        String exact_name = version + "##" + name;
        Caffeineson cache = this.instanceMap.get(exact_name);
        if (cache != null) {
            return cache;
        }
        CaffeinesonConfig caffeineconfig = this.configs.get(name);
        if (caffeineconfig == null) {
            caffeineconfig = this.createCaffeinesonConfig();
            this.configs.put(name, caffeineconfig);
        }
        return this.buildCache(name);
    }

    public Collection<String> getCacheNames() {
        return this.versionMap.keySet();
    }

    @Override
    public void evictVersion(String cacheName, long version) {
        String exact_name = version + "##" + cacheName;
        Caffeineson cache = (Caffeineson)this.getCacheIfExist(exact_name);
        if (cache != null) {
            cache.clear();
            this.instanceMap.remove(exact_name);
        }
    }

    @Override
    public void evict(String cacheName) {
        long version = this.versionMap.get(cacheName);
        this.evictVersion(cacheName, version);
    }

    @Override
    public long version(String cacheName) {
        Long version = this.versionMap.get(cacheName);
        return version == null ? 0L : version;
    }

    @Override
    public void version(String cacheName, long version) {
        long lastVersion = this.version(cacheName);
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u7248\u672c {} \u5230 {}", (Object)lastVersion, (Object)version);
        }
        this.evictVersion(cacheName, lastVersion);
        this.versionMap.put(cacheName, version);
    }

    @Override
    public void init(String cacheName, long version) {
        Long cur_version;
        if (log.isDebugEnabled()) {
            log.debug("\u521d\u59cb\u5316\u7248\u672c {}", (Object)version);
        }
        if ((cur_version = this.versionMap.get(cacheName)) == null) {
            this.versionMap.put(cacheName, cur_version);
        }
    }

    @Override
    public Cache getCacheIfExist(String cacheName) {
        return (Cache)this.instanceMap.get(cacheName);
    }
}

