/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine.cache;

import cn.aradin.spring.caffeine.cache.config.CaffeinesonConfig;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class Caffeineson
extends AbstractValueAdaptingCache {
    private Cache<Object, Object> caffeineCache;
    private final String group;
    private final String name;
    private final boolean versioned;
    private IVersionBroadHandler versionBroadHandler;

    public Caffeineson(String name, String group, boolean versioned, CaffeinesonConfig caffeineConfig, RemovalListener<Object, Object> listener, IVersionBroadHandler versionBroadHandler) {
        super(caffeineConfig.isAllowNullValues());
        this.caffeineCache = this.caffeineCache(caffeineConfig, listener);
        this.name = name;
        this.versioned = versioned;
        this.versionBroadHandler = versionBroadHandler;
        this.group = group;
    }

    protected Cache<Object, Object> caffeineCache(CaffeinesonConfig config, RemovalListener<Object, Object> listener) {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        if (config.getExpireAfterAccess() > 0L) {
            cacheBuilder.expireAfterAccess(config.getExpireAfterAccess(), TimeUnit.MILLISECONDS);
        }
        if (config.getExpireAfterWrite() > 0L) {
            cacheBuilder.expireAfterWrite(config.getExpireAfterWrite(), TimeUnit.MILLISECONDS);
        }
        if (config.getInitialCapacity() > 0) {
            cacheBuilder.initialCapacity(config.getInitialCapacity());
        }
        if (config.getMaximumSize() > 0L) {
            cacheBuilder.maximumSize(config.getMaximumSize());
        }
        if (config.getRefreshAfterWrite() > 0L) {
            cacheBuilder.refreshAfterWrite(config.getRefreshAfterWrite(), TimeUnit.MILLISECONDS);
        }
        if (config.isSoft()) {
            cacheBuilder.softValues();
        }
        if (listener != null) {
            cacheBuilder.removalListener(listener);
        }
        return cacheBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.caffeineCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value == null) {
            String string = key.toString().intern();
            synchronized (string) {
                try {
                    value = this.lookup(key);
                    if (value != null) {
                        return (T)value;
                    }
                    value = valueLoader.call();
                    this.put(key, value);
                }
                catch (Exception e) {
                    try {
                        Class<?> c = Class.forName("org.springframework.cache.Cache$ValueRetrievalException");
                        Constructor<?> constructor = c.getConstructor(Object.class, Callable.class, Throwable.class);
                        RuntimeException exception = (RuntimeException)constructor.newInstance(key, valueLoader, e.getCause());
                        throw exception;
                    }
                    catch (Exception e1) {
                        throw new IllegalStateException(e1);
                    }
                }
            }
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        this.caffeineCache.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object prevValue = this.caffeineCache.getIfPresent(key);
        if (prevValue == null) {
            String string = key.toString().intern();
            synchronized (string) {
                prevValue = this.caffeineCache.getIfPresent(key);
                if (prevValue == null) {
                    this.caffeineCache.put(key, value);
                    prevValue = value;
                }
            }
        }
        return this.toValueWrapper(prevValue);
    }

    public void evict(Object key) {
        this.caffeineCache.invalidate(key);
        if (this.versioned) {
            this.versionBroadHandler.broadcast(this.group, this.name);
        }
    }

    public void clear() {
        this.caffeineCache.invalidateAll();
    }

    protected Object lookup(Object key) {
        return this.caffeineCache.getIfPresent(key);
    }

    public CacheStats stats() {
        return this.caffeineCache.stats();
    }
}

