/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.actuator.starter.actuate;

import cn.aradin.spring.actuator.starter.properties.ActuatorOnlineProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="online", enableByDefault=true)
public class OnlineEndpoint {
    private static final Logger log = LoggerFactory.getLogger(OnlineEndpoint.class);
    private static final Map<String, String> ONLINE_MESSAGE = Collections.unmodifiableMap(Collections.singletonMap("message", "Online Success"));
    private final ActuatorOnlineProperties actuatorOnlineProperties;

    public OnlineEndpoint(ActuatorOnlineProperties actuatorOnlineProperties) {
        this.actuatorOnlineProperties = actuatorOnlineProperties;
    }

    @ReadOperation
    public Map<String, String> online() {
        if (StringUtils.isNotBlank((CharSequence)this.actuatorOnlineProperties.getShell())) {
            String bashCommand = "sh " + this.actuatorOnlineProperties.getShell();
            Runtime runtime = Runtime.getRuntime();
            try {
                Process process = runtime.exec(bashCommand);
                int status = process.waitFor();
                if (status != 0) {
                    if (log.isWarnEnabled()) {
                        log.warn("Filebeat Start Error {}", (Object)status);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Filebeat start OK");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ONLINE_MESSAGE;
    }
}

