/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.actuator.consul.starter.lifestyle;

import cn.aradin.spring.actuator.starter.extension.IOfflineHandler;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.Service;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.context.ApplicationContext;

public class AradinConsulOfflineHandler
implements IOfflineHandler {
    private static final Logger log = LoggerFactory.getLogger(AradinConsulOfflineHandler.class);
    private final ConsulClient consulClient;
    private final ConsulRegistration consulRegistration;

    public AradinConsulOfflineHandler(ConsulClient consulClient, ConsulRegistration consulRegistration) {
        this.consulClient = consulClient;
        this.consulRegistration = consulRegistration;
    }

    public void offline(ApplicationContext context) {
        String currentInstanceId = this.consulRegistration.getInstanceId();
        List members = (List)this.consulClient.getAgentMembers().getValue();
        for (Member member : members) {
            String address = member.getAddress();
            ConsulClient clearClient = new ConsulClient(address);
            try {
                Map serviceMap = (Map)clearClient.getAgentServices().getValue();
                for (Map.Entry entry : serviceMap.entrySet()) {
                    Service service = (Service)entry.getValue();
                    String instanceId = service.getId();
                    if (!currentInstanceId.equals(instanceId)) continue;
                    log.warn("\u5728{}\u5ba2\u6237\u7aef\u4e0a\u7684\u670d\u52a1 :{}\uff0c\u51c6\u5907\u6e05\u7406...................", (Object)address, (Object)currentInstanceId);
                    clearClient.agentServiceDeregister(currentInstanceId);
                }
            }
            catch (Exception e) {
                log.error("\u5f02\u5e38\u4fe1\u606f: {}", (Throwable)e);
            }
        }
    }
}

