/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http.support;

import cn.aradin.easy.http.support.HttpClientFactory;
import cn.aradin.easy.http.support.JsonResponseHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(LocalHttpClient.class);
    private static final String caller = System.getProperty("aradin.http.caller");
    protected static HttpClient httpClient = HttpClientFactory.createHttpClient(100, 20);
    private static Map<String, HttpClient> httpClient_mchKeyStore = new HashMap<String, HttpClient>();

    public static void init(int maxTotal, int maxPerRoute) {
        httpClient = HttpClientFactory.createHttpClient(maxTotal, maxPerRoute);
    }

    public static void initMchKeyStore(String keyStoreName, String keyStoreFilePath, String mch_id, int maxTotal, int maxPerRoute) {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreName);
            InputStream instream = LocalHttpClient.class.getClassLoader().getResourceAsStream(keyStoreFilePath);
            keyStore.load(instream, mch_id.toCharArray());
            instream.close();
            HttpClient httpClient = HttpClientFactory.createKeyMaterialHttpClient(keyStore, mch_id, new String[]{"TLSv1"}, maxTotal, maxPerRoute);
            httpClient_mchKeyStore.put(mch_id, httpClient);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HttpResponse execute(HttpUriRequest request) {
        try {
            return httpClient.execute(request);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T execute(HttpUriRequest request, ResponseHandler<T> responseHandler) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(request.getMethod() + " " + request.getURI());
        }
        if (StringUtils.isNotBlank((CharSequence)caller)) {
            request.addHeader("EASY-CALLER", caller);
        }
        return (T)httpClient.execute(request, responseHandler);
    }

    public static <T> T executeJsonResult(HttpUriRequest request, Type clazz) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(request.getMethod() + " " + request.getURI());
        }
        return (T)LocalHttpClient.execute(request, JsonResponseHandler.createResponseHandler(clazz));
    }
}

