/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http;

import cn.aradin.easy.http.support.LocalHttpClient;
import cn.aradin.easy.http.support.RequestMethod;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyRequest {
    private static final Logger logger = LoggerFactory.getLogger(EasyRequest.class);

    public <T> T request(String url, Type returnClaz, RequestMethod method, Map<String, String> headers, Map<String, String> postObj, String postBody, RequestConfig requestConfig, String contentType) throws Exception {
        if (requestConfig == null) {
            requestConfig = RequestConfig.custom().build();
        }
        try {
            if (RequestMethod.GET.equals((Object)method) || method == null) {
                HttpUriRequest request = RequestBuilder.get().setUri(url).setConfig(requestConfig).build();
                this.fixHeaders(request, headers);
                return LocalHttpClient.executeJsonResult(request, returnClaz);
            }
            if (RequestMethod.POST.equals((Object)method)) {
                RequestBuilder builder = RequestBuilder.post().setUri(url);
                if (postObj != null && postObj.size() > 0) {
                    ArrayList<BasicNameValuePair> array = new ArrayList<BasicNameValuePair>();
                    for (String key : postObj.keySet()) {
                        if (!StringUtils.isNotBlank((CharSequence)key) || postObj.get(key) == null) continue;
                        BasicNameValuePair valuePair = new BasicNameValuePair(key, postObj.get(key));
                        array.add(valuePair);
                    }
                    builder.setEntity((HttpEntity)new UrlEncodedFormEntity(array, "UTF-8"));
                } else if (StringUtils.isNotBlank((CharSequence)postBody)) {
                    builder.setEntity((HttpEntity)new StringEntity(postBody, StringUtils.isNotBlank((CharSequence)contentType) ? ContentType.parse((String)contentType) : ContentType.APPLICATION_JSON));
                }
                HttpUriRequest request = builder.build();
                this.fixHeaders(request, headers);
                return LocalHttpClient.executeJsonResult(request, returnClaz);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("request is error\u3002[" + url + "]", (Throwable)e);
            throw e;
        }
    }

    private void fixHeaders(HttpUriRequest request, Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                request.addHeader(key, headers.get(key));
            }
        }
    }
}

