/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http;

import cn.aradin.easy.http.EasyRequest;
import cn.aradin.easy.http.annotation.Controller;
import cn.aradin.easy.http.annotation.RequestBody;
import cn.aradin.easy.http.annotation.RequestHeader;
import cn.aradin.easy.http.annotation.RequestMapping;
import cn.aradin.easy.http.annotation.RequestParam;
import cn.aradin.easy.http.annotation.support.EncryptHolder;
import cn.aradin.easy.http.support.RequestMethod;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyInvocation
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(EasyInvocation.class);
    private Class<?> target;
    private String domain;
    private EasyRequest clent;
    private RequestConfig requestConfig;

    public EasyInvocation(EasyRequest client, RequestConfig requestConfig) {
        this.clent = client;
        this.requestConfig = requestConfig;
    }

    public <T> T create(Class<T> target) {
        this.target = target;
        Controller s = target.getAnnotation(Controller.class);
        if (s != null) {
            if (StringUtils.isNotBlank((CharSequence)s.param())) {
                this.domain = System.getProperty(s.param());
            }
            if (StringUtils.isBlank((CharSequence)this.domain)) {
                this.domain = s.value();
            }
            if (StringUtils.isBlank((CharSequence)this.domain)) {
                logger.error(target.getName() + ",\u6ca1\u6709\u5b9a\u4e49 @Controller\u53c2\u6570\uff01");
                throw new RuntimeException("@Controller\u53c2\u6570\u4e0d\u5168\uff0cvalue or param");
            }
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{target}, (InvocationHandler)this);
        }
        logger.error(target.getName() + ",\u6ca1\u6709\u5b9a\u4e49 @Controller\uff01");
        return null;
    }

    public String getDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RequestMapping m = method.getAnnotation(RequestMapping.class);
        Type returnClaz = method.getGenericReturnType();
        if (m == null) {
            logger.error(this.target.getName() + "." + method.getName() + ",\u6ca1\u6709\u5b9a\u4e49@RequestMapping!");
            return null;
        }
        int retries = m.retries();
        int i = 0;
        while (true) {
            try {
                String contentType = m.contentType();
                StringBuilder builder = new StringBuilder(this.domain);
                builder.append(m.value());
                String body = this.parseBody(method, args);
                if (logger.isDebugEnabled()) {
                    logger.debug("Invoke body {}", (Object)body);
                }
                Map<String, String> headers = this.parseHeaders(method, args);
                if (RequestMethod.POST.equals((Object)m.method())) {
                    Map<String, String> values = null;
                    if (StringUtils.isNotBlank((CharSequence)body)) {
                        String params = this.parseToString(method, args);
                        if (params != null) {
                            builder.append("?");
                            builder.append(params);
                        }
                    } else {
                        values = this.parseParameters(method, args);
                    }
                    Object t = this.clent.request(builder.toString(), returnClaz, RequestMethod.POST, headers, values, body, this.requestConfig, contentType);
                    return t;
                }
                String params = this.parseToString(method, args);
                if (params != null) {
                    builder.append("?");
                    builder.append(params);
                }
                Object t = this.clent.request(builder.toString(), returnClaz, RequestMethod.GET, headers, null, body, this.requestConfig, contentType);
                return t;
            }
            catch (Exception e) {
                logger.error(this.target.getName() + "." + method.getName() + ",\u8c03\u7528\u5f02\u5e38,\u91cd\u8bd5!\n{}", (Object)e.getMessage());
                if (i < retries) continue;
                e.printStackTrace();
                logger.error(this.target.getName() + "." + method.getName() + ",\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570!\\n{}", (Object)e.getMessage());
                Object var9_10 = null;
                return var9_10;
            }
            finally {
                ++i;
                continue;
            }
            break;
        }
    }

    protected Map<String, String> parseHeaders(Method method, Object[] args) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter;
                RequestHeader requestHeader;
                if (args[i] == null || (requestHeader = (parameter = parameters[i]).getAnnotation(RequestHeader.class)) == null) continue;
                values.put(requestHeader.value(), EncryptHolder.function(requestHeader.encrypt()).apply(String.valueOf(args[i])));
            }
        }
        return values;
    }

    protected Map<String, String> parseParameters(Method method, Object[] args) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (args[i] == null) continue;
                Parameter parameter = parameters[i];
                Annotation[] annotations = parameter.getAnnotations();
                if (annotations != null && annotations.length > 0) {
                    RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
                    if (requestParam == null) continue;
                    values.put(requestParam.value(), String.valueOf(args[i]));
                    continue;
                }
                if (parameter.getType().isAssignableFrom(Map.class)) {
                    Map paramData = (Map)args[i];
                    for (Object key : paramData.keySet()) {
                        if (paramData.get(key) == null) continue;
                        values.put(String.valueOf(key), String.valueOf(paramData.get(key)));
                    }
                    continue;
                }
                Class<?> paramClass = parameter.getType();
                Field[] fields = paramClass.getDeclaredFields();
                if (fields == null || fields.length <= 0) continue;
                for (Field field : fields) {
                    try {
                        if ("serialVersionUID".equals(field.getName())) continue;
                        field.setAccessible(true);
                        Object fieldValue = field.get(args[i]);
                        if (fieldValue == null) continue;
                        values.put(field.getName(), String.valueOf(fieldValue));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return values;
    }

    protected String parseBody(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter;
                RequestBody requestBody;
                if (args[i] == null || (requestBody = (parameter = parameters[i]).getAnnotation(RequestBody.class)) == null) continue;
                String result = null;
                result = parameter.getType().isAssignableFrom(String.class) || parameter.getType().isAssignableFrom(Integer.class) || parameter.getType().isAssignableFrom(Long.class) || parameter.getType().isAssignableFrom(Float.class) || parameter.getType().isAssignableFrom(Double.class) || parameter.getType().isAssignableFrom(Boolean.class) ? String.valueOf(args[i]) : JSONObject.toJSONString((Object)args[i], (JSONWriter.Feature[])new JSONWriter.Feature[0]);
                return EncryptHolder.function(requestBody.encrypt()).apply(result);
            }
        }
        return null;
    }

    protected String parseToString(Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        try {
            Map<String, String> parameters = this.parseParameters(method, args);
            int valid = 0;
            for (String name : parameters.keySet()) {
                if (valid > 0) {
                    builder.append("&");
                }
                builder.append(name);
                builder.append("=");
                builder.append(URLEncoder.encode(parameters.get(name), "utf-8"));
                ++valid;
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String[] getMethodParameterNamesByAnnotation(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations == null || parameterAnnotations.length == 0) {
            return null;
        }
        String[] parameterNames = new String[parameterAnnotations.length];
        int i = 0;
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = annotationArray[j]) {
                if (!(annotation instanceof RequestParam)) continue;
                RequestParam param = (RequestParam)annotation;
                parameterNames[i++] = param.value();
            }
        }
        return parameterNames;
    }
}

