/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http.support;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponseHandler {
    private static Map<String, ResponseHandler<?>> map = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(JsonResponseHandler.class);

    public static ResponseHandler<Object> createResponseHandler(final Type clazz) {
        if (map.containsKey(clazz.getTypeName())) {
            return map.get(clazz.getTypeName());
        }
        ResponseHandler<Object> responseHandler = new ResponseHandler<Object>(){

            public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    String str = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("utf-8"));
                    logger.debug("\u8fd4\u56de\u7ed3\u679c\u300b\u300b\u300b\u300b\u300b" + str);
                    if (String.class.equals((Object)clazz)) {
                        return str;
                    }
                    if (Integer.class.equals((Object)clazz)) {
                        return Integer.parseInt(str);
                    }
                    if (Long.class.equals((Object)clazz)) {
                        return Long.parseLong(str);
                    }
                    return JSONObject.parseObject((String)str, (TypeReference)TypeReference.get((Type)clazz), (JSONReader.Feature[])new JSONReader.Feature[0]);
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        };
        map.put(clazz.getTypeName(), responseHandler);
        return responseHandler;
    }
}

