/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http;

import cn.aradin.easy.http.EasyInvocation;
import cn.aradin.easy.http.EasyRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EasyBuilder.class);
    public Map<Class<?>, Object> serviceMap = new HashMap();
    private static EasyBuilder factory;
    private static ReentrantLock lock;
    private EasyRequest client = new EasyRequest();

    private EasyBuilder() {
    }

    public static EasyBuilder ins() {
        if (factory == null) {
            lock.lock();
            if (factory == null) {
                factory = new EasyBuilder();
            }
            lock.unlock();
        }
        return factory;
    }

    public <T> T service(Class<T> serviceInterface) {
        return this.service(serviceInterface, null);
    }

    public <T> T service(Class<T> serviceInterface, RequestConfig requestConfig) {
        if (this.serviceMap.containsKey(serviceInterface)) {
            logger.debug("Service\u5b58\u5728" + serviceInterface);
            return (T)this.serviceMap.get(serviceInterface);
        }
        logger.debug("Service\u4e0d\u5b58\u5728" + serviceInterface);
        return this.add(serviceInterface, requestConfig);
    }

    private <T> T add(Class<T> serviceInterface, RequestConfig requestConfig) {
        EasyInvocation handler = new EasyInvocation(this.client, requestConfig);
        T t = handler.create(serviceInterface);
        this.serviceMap.put(serviceInterface, t);
        return t;
    }

    static {
        lock = new ReentrantLock();
    }
}

