/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http.buddy;

import cn.aradin.easy.http.EasyRequest;
import cn.aradin.easy.http.annotation.RequestBody;
import cn.aradin.easy.http.annotation.RequestHeader;
import cn.aradin.easy.http.annotation.RequestMapping;
import cn.aradin.easy.http.annotation.RequestParam;
import cn.aradin.easy.http.annotation.support.EncryptHolder;
import cn.aradin.easy.http.support.RequestMethod;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuddyInvocation {
    private static final Logger logger = LoggerFactory.getLogger(BuddyInvocation.class);
    private String domain;
    private EasyRequest clent = new EasyRequest();
    private RequestConfig requestConfig;

    public BuddyInvocation(String domain, RequestConfig requestConfig) {
        this.domain = domain;
        this.requestConfig = requestConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args) throws IOException {
        RequestMapping m = method.getAnnotation(RequestMapping.class);
        Type returnClaz = method.getGenericReturnType();
        if (m == null) {
            logger.error(returnClaz.getTypeName() + "." + method.getName() + ",\u6ca1\u6709\u5b9a\u4e49@RequestMapping!");
            return null;
        }
        int retries = m.retries();
        int i = 0;
        while (true) {
            try {
                String contentType = m.contentType();
                StringBuilder builder = new StringBuilder(this.domain);
                builder.append(m.value());
                String body = this.parseBody(method, args);
                Map<String, String> headers = this.parseHeaders(method, args);
                if (RequestMethod.POST.equals((Object)m.method())) {
                    Map<String, String> values = null;
                    if (StringUtils.isNotBlank((CharSequence)body)) {
                        String params = this.parseToString(method, args);
                        if (params != null) {
                            builder.append("?");
                            builder.append(params);
                        }
                    } else {
                        values = this.parseParameters(method, args);
                    }
                    Object object = this.clent.request(builder.toString(), returnClaz, RequestMethod.POST, headers, values, body, this.requestConfig, contentType);
                    return object;
                }
                String params = this.parseToString(method, args);
                if (params != null) {
                    builder.append("?");
                    builder.append(params);
                }
                Object object = this.clent.request(builder.toString(), returnClaz, RequestMethod.GET, headers, null, body, this.requestConfig, contentType);
                return object;
            }
            catch (Exception e) {
                logger.error(returnClaz.getTypeName() + "." + method.getName() + ",\u8c03\u7528\u5f02\u5e38,\u91cd\u8bd5!");
                if (i < retries) continue;
                logger.error(returnClaz.getTypeName() + "." + method.getName() + ",\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570!");
                Object var8_9 = null;
                return var8_9;
            }
            finally {
                ++i;
                continue;
            }
            break;
        }
    }

    protected Map<String, String> parseHeaders(Method method, Object[] args) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter;
                RequestHeader requestHeader;
                if (args[i] == null || (requestHeader = (parameter = parameters[i]).getAnnotation(RequestHeader.class)) == null) continue;
                values.put(requestHeader.value(), (String)EncryptHolder.function((Class)requestHeader.encrypt()).apply(String.valueOf(args[i])));
            }
        }
        return values;
    }

    protected Map<String, String> parseParameters(Method method, Object[] args) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (args[i] == null) continue;
                Parameter parameter = parameters[i];
                Annotation[] annotations = parameter.getAnnotations();
                if (annotations != null && annotations.length > 0) {
                    RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
                    if (requestParam == null) continue;
                    values.put(requestParam.value(), String.valueOf(args[i]));
                    continue;
                }
                if (parameter.getType().isAssignableFrom(Map.class)) {
                    Map paramData = (Map)args[i];
                    for (Object key : paramData.keySet()) {
                        if (paramData.get(key) == null) continue;
                        values.put(String.valueOf(key), String.valueOf(paramData.get(key)));
                    }
                    continue;
                }
                Class<?> paramClass = parameter.getType();
                Field[] fields = paramClass.getDeclaredFields();
                if (fields == null || fields.length <= 0) continue;
                for (Field field : fields) {
                    try {
                        if ("serialVersionUID".equals(field.getName())) continue;
                        field.setAccessible(true);
                        Object fieldValue = field.get(args[i]);
                        if (fieldValue == null) continue;
                        values.put(field.getName(), String.valueOf(fieldValue));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return values;
    }

    protected String parseBody(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter;
                RequestBody requestBody;
                if (args[i] == null || (requestBody = (parameter = parameters[i]).getAnnotation(RequestBody.class)) == null) continue;
                String result = null;
                result = parameter.getType().isAssignableFrom(String.class) || parameter.getType().isAssignableFrom(Integer.class) || parameter.getType().isAssignableFrom(Long.class) || parameter.getType().isAssignableFrom(Float.class) || parameter.getType().isAssignableFrom(Double.class) || parameter.getType().isAssignableFrom(Boolean.class) ? String.valueOf(args[i]) : JSONObject.toJSONString((Object)args[i], (JSONWriter.Feature[])new JSONWriter.Feature[0]);
                return (String)EncryptHolder.function((Class)requestBody.encrypt()).apply(result);
            }
        }
        return null;
    }

    protected String parseToString(Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        try {
            Map<String, String> parameters = this.parseParameters(method, args);
            int valid = 0;
            for (String name : parameters.keySet()) {
                if (valid > 0) {
                    builder.append("&");
                }
                builder.append(name);
                builder.append("=");
                builder.append(URLEncoder.encode(parameters.get(name), "utf-8"));
                ++valid;
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

