/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.easy.http.buddy;

import cn.aradin.easy.http.annotation.Controller;
import cn.aradin.easy.http.buddy.BuddyInvocation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuddyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BuddyBuilder.class);
    public Map<Class<?>, Object> serviceMap = new HashMap();
    private static BuddyBuilder factory;
    private static ReentrantLock lock;

    public static BuddyBuilder ins() {
        if (factory == null) {
            lock.lock();
            if (factory == null) {
                factory = new BuddyBuilder();
            }
            lock.unlock();
        }
        return factory;
    }

    public <T> T service(Class<T> serviceInterface) {
        return this.service(serviceInterface, null);
    }

    public <T> T service(Class<T> serviceInterface, RequestConfig requestConfig) {
        if (this.serviceMap.containsKey(serviceInterface)) {
            logger.debug("Service\u5b58\u5728" + serviceInterface);
            return (T)this.serviceMap.get(serviceInterface);
        }
        logger.debug("Service\u4e0d\u5b58\u5728" + serviceInterface);
        try {
            T t = this.create(serviceInterface);
            this.serviceMap.put(serviceInterface, t);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public <T> T create(Class<T> interfaceClazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Controller s = interfaceClazz.getAnnotation(Controller.class);
        String domain = null;
        if (s != null) {
            if (StringUtils.isNotBlank((CharSequence)s.param())) {
                domain = System.getProperty(s.param());
            }
            if (StringUtils.isBlank(domain)) {
                domain = s.value();
            }
        }
        if (StringUtils.isBlank(domain)) {
            logger.error(interfaceClazz.getName() + ",\u6ca1\u6709\u5b9a\u4e49 @Controller\u53c2\u6570\uff01");
            throw new RuntimeException("@Controller\u53c2\u6570\u4e0d\u5168\uff0cvalue or param");
        }
        ByteBuddy buddy = new ByteBuddy();
        return buddy.subclass(interfaceClazz).name(BuddyBuilder.getNewClassName(interfaceClazz)).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)new BuddyInvocation(domain, null))).make().load(BuddyBuilder.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static String getNewClassName(Class<?> clazz) {
        return clazz.getSimpleName() + "Impl";
    }

    static {
        lock = new ReentrantLock();
    }
}

