/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.cluster.zookeeper.starter.handler;

import cn.aradin.cluster.core.manager.IClusterNodeManager;
import cn.aradin.cluster.core.properties.ClusterProperties;
import cn.aradin.spring.core.enums.RegisterType;
import cn.aradin.zookeeper.boot.starter.handler.INodeHandler;
import cn.aradin.zookeeper.boot.starter.manager.ZookeeperClientManager;
import cn.aradin.zookeeper.boot.starter.properties.Zookeeper;
import cn.aradin.zookeeper.boot.starter.properties.ZookeeperProperties;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeHandler
implements INodeHandler {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeHandler.class);
    private ClusterProperties clusterProperties;
    private IClusterNodeManager clusterNodeManager;
    private Integer registerRetry = 0;

    public ClusterNodeHandler(ClusterProperties clusterProperties, ZookeeperProperties zookeeperProperties, IClusterNodeManager clusterNodeManager) {
        Optional<Zookeeper> result;
        if (clusterProperties == null) {
            throw new RuntimeException("Cluster is not config");
        }
        if (!RegisterType.zookeeper.equals((Object)clusterProperties.getRegisterType())) {
            throw new RuntimeException("Cluster is not registed on zookeeper");
        }
        this.clusterProperties = clusterProperties;
        if (zookeeperProperties != null && clusterProperties != null && CollectionUtils.isNotEmpty((Collection)zookeeperProperties.getAddresses()) && (result = zookeeperProperties.getAddresses().stream().filter(zookeeper -> zookeeper.getId().equals(clusterProperties.getZookeeperAddressId())).findAny()).isPresent()) {
            this.clusterNodeManager = clusterNodeManager;
            return;
        }
        throw new RuntimeException("Cluster's Zookeeper is not config");
    }

    private Integer rebaseNode(List<String> existNodes, Integer maxNode) {
        if (existNodes == null || existNodes.size() == 0) {
            return 0;
        }
        if (existNodes.size() >= maxNode) {
            throw new RuntimeException("Cluster Node Is OutSize With Nodes " + JSONObject.toJSONString(existNodes));
        }
        ArrayList nodes = Lists.newArrayList();
        existNodes.forEach(existNode -> {
            if (StringUtils.isNumeric((CharSequence)existNode)) {
                nodes.add(Integer.parseInt(existNode));
            }
        });
        Collections.sort(nodes);
        for (int i = 0; i < maxNode; ++i) {
            if (nodes.size() > i) {
                if ((Integer)nodes.get(i) == i) continue;
                return i;
            }
            return i;
        }
        throw new RuntimeException("Cluster Node Is OutSize");
    }

    private void registerNode(CuratorFramework client, String nodeName) {
        Integer n = this.registerRetry;
        Integer n2 = this.registerRetry = Integer.valueOf(this.registerRetry + 1);
        if (n > 5) {
            this.registerRetry = 0;
            throw new RuntimeException("Cluster Node Retry Too Many Times");
        }
        Integer index = -1;
        try {
            List childs = (List)client.getChildren().forPath("/" + this.clusterProperties.getZookeeperAddressId());
            index = this.rebaseNode(childs, this.clusterProperties.getMaxNode());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getCause());
        }
        try {
            ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath("/" + this.clusterProperties.getZookeeperAddressId() + "/" + String.valueOf(index), this.clusterProperties.getNodeName().getBytes());
            this.registerRetry = 0;
            this.clusterNodeManager.setCurrentIndex(index.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (log.isWarnEnabled()) {
                log.warn("Cluster Register Retry Failed {}", (Object)this.registerRetry);
            }
            this.registerNode(client, nodeName);
        }
    }

    public void init(ZookeeperClientManager clientManager) {
        if (StringUtils.isBlank((CharSequence)this.clusterProperties.getNodeName())) {
            try {
                if (this.clusterProperties.isPreferIpAddress()) {
                    this.clusterProperties.setNodeName(Inet4Address.getLocalHost().getHostAddress());
                } else {
                    this.clusterProperties.setNodeName(Inet4Address.getLocalHost().getHostName());
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getCause());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Node Registing, {}", (Object)this.clusterProperties.getNodeName());
        }
        CuratorFramework client = clientManager.getClient(this.clusterProperties.getZookeeperAddressId());
        try {
            this.registerNode(client, this.clusterProperties.getNodeName());
            client.getConnectionStateListenable().addListener((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (log.isErrorEnabled()) {
                log.error("Node Registed Failed, {}", (Object)e.getMessage());
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private boolean supportPath(String path) {
        if (path.contains("/") && (path = path.substring(0, path.lastIndexOf("/"))).contains("/")) {
            String cluster = path.substring(path.lastIndexOf("/") + 1);
            if (log.isDebugEnabled()) {
                log.debug("Parse Cluster {}", (Object)cluster);
            }
            if (this.clusterProperties.getZookeeperAddressId().equalsIgnoreCase(cluster)) {
                return true;
            }
        }
        return false;
    }

    public boolean support(PathChildrenCacheEvent event) {
        String path = event.getData().getPath();
        if (log.isDebugEnabled()) {
            log.debug("Received Event Path {} {}", (Object)path, (Object)event.getType());
        }
        return this.supportPath(path);
    }

    public void handler(CuratorFramework client, PathChildrenCacheEvent event) {
        try {
            switch (event.getType()) {
                case INITIALIZED: {
                    if (!CollectionUtils.isNotEmpty((Collection)event.getInitialData())) break;
                    HashMap nodes = new HashMap(this.clusterProperties.getMaxNode());
                    event.getInitialData().forEach(data -> {
                        String path;
                        if (this.supportPath(data.getPath()) && StringUtils.isNumeric((CharSequence)(path = data.getPath().substring(data.getPath().lastIndexOf("/") + 1)))) {
                            nodes.put(Integer.parseInt(path), new String(data.getData()));
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug("Find Cluster Nodes {}", (Object)JSONObject.toJSONString(nodes));
                    }
                    this.clusterNodeManager.nodeInit(nodes);
                    break;
                }
                case CHILD_ADDED: {
                    String node = event.getData().getPath().substring(event.getData().getPath().lastIndexOf("/") + 1);
                    if (log.isDebugEnabled()) {
                        log.debug("Node Adding {}", (Object)node);
                    }
                    if (!StringUtils.isNumeric((CharSequence)node)) break;
                    this.clusterNodeManager.nodeAdded(Integer.valueOf(Integer.parseInt(node)), new String(event.getData().getData()));
                    if (!log.isDebugEnabled()) break;
                    log.debug("Node Added {}", (Object)JSONObject.toJSONString((Object)this.clusterNodeManager.nodeNames()));
                    break;
                }
                case CHILD_REMOVED: {
                    String node = event.getData().getPath().substring(event.getData().getPath().lastIndexOf("/") + 1);
                    if (log.isDebugEnabled()) {
                        log.debug("Node Removing {}", (Object)node);
                    }
                    if (!StringUtils.isNumeric((CharSequence)node)) break;
                    this.clusterNodeManager.nodeRemoved(Integer.valueOf(Integer.parseInt(node)), new String(event.getData().getData()));
                    if (!log.isDebugEnabled()) break;
                    log.debug("Node Removed {}", (Object)JSONObject.toJSONString((Object)this.clusterNodeManager.nodeNames()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (newState == ConnectionState.LOST) {
            while (true) {
                try {
                    while (!client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                    }
                    this.registerNode(client, this.clusterProperties.getNodeName());
                    log.error("Re Register Succeed {}", (Object)this.clusterProperties.getNodeName());
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.error("Re Register Failed {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

