/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.cluster.zookeeper.starter.handler;

import cn.aradin.cluster.core.manager.IClusterNodeManager;
import cn.aradin.cluster.core.properties.ClusterProperties;
import cn.aradin.spring.core.enums.RegisterType;
import cn.aradin.zookeeper.boot.starter.handler.INodeHandler;
import cn.aradin.zookeeper.boot.starter.manager.ZookeeperClientManager;
import cn.aradin.zookeeper.boot.starter.properties.Zookeeper;
import cn.aradin.zookeeper.boot.starter.properties.ZookeeperProperties;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeHandler
implements INodeHandler {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeHandler.class);
    private ClusterProperties clusterProperties;
    private IClusterNodeManager clusterNodeManager;

    public ClusterNodeHandler(ClusterProperties clusterProperties, ZookeeperProperties zookeeperProperties, IClusterNodeManager clusterNodeManager) {
        Optional<Zookeeper> result;
        if (clusterProperties == null) {
            throw new RuntimeException("Cluster is not config");
        }
        if (!RegisterType.zookeeper.equals((Object)clusterProperties.getRegisterType())) {
            throw new RuntimeException("Cluster is not registed on zookeeper");
        }
        this.clusterProperties = clusterProperties;
        if (zookeeperProperties != null && clusterProperties != null && CollectionUtils.isNotEmpty((Collection)zookeeperProperties.getAddresses()) && !(result = zookeeperProperties.getAddresses().stream().filter(zookeeper -> zookeeper.getId().equals(clusterProperties.getZookeeperAddressId())).findAny()).isPresent()) {
            return;
        }
        throw new RuntimeException("Cluster's Zookeeper is not config");
    }

    public void init(ZookeeperClientManager clientManager) {
        if (StringUtils.isBlank((CharSequence)this.clusterProperties.getNodeName())) {
            try {
                if (this.clusterProperties.isPreferIpAddress()) {
                    this.clusterProperties.setNodeName(Inet4Address.getLocalHost().getHostAddress());
                } else {
                    this.clusterProperties.setNodeName(Inet4Address.getLocalHost().getHostName());
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getCause());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Node Registing, {}", (Object)this.clusterProperties.getNodeName());
        }
        CuratorFramework client = clientManager.getClient(this.clusterProperties.getZookeeperAddressId());
        try {
            ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(this.clusterProperties.getNodeName());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (log.isErrorEnabled()) {
                log.error("Node Registed Failed, {}", (Object)e.getMessage());
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public boolean support(PathChildrenCacheEvent event) {
        String path = event.getData().getPath();
        if ((path = path.substring(0, path.lastIndexOf("/"))).contains("/")) {
            String cluster = path.substring(path.lastIndexOf("/") + 1);
            if (this.clusterProperties.getZookeeperAddressId().equalsIgnoreCase(cluster)) {
                return true;
            }
        }
        return false;
    }

    public void handler(CuratorFramework client, PathChildrenCacheEvent event) {
        switch (event.getType()) {
            case INITIALIZED: {
                if (!CollectionUtils.isNotEmpty((Collection)event.getInitialData())) break;
                HashSet nodes = new HashSet();
                event.getInitialData().forEach(data -> nodes.add(data.getPath()));
                this.clusterNodeManager.nodeInit(nodes);
                break;
            }
            case CHILD_ADDED: {
                this.clusterNodeManager.nodeAdded(event.getData().getPath());
                break;
            }
            case CHILD_REMOVED: {
                this.clusterNodeManager.nodeRemoved(event.getData().getPath());
                break;
            }
        }
    }
}

