/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.cluster.nacos.starter.handler;

import cn.aradin.cluster.core.manager.IClusterNodeManager;
import cn.aradin.cluster.core.properties.ClusterProperties;
import cn.aradin.cluster.nacos.starter.properties.ClusterNacosProperties;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.util.Assert;

public class ClusterNacosNodeHandler
implements EventListener,
ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ClusterNacosNodeHandler.class);
    private final String serviceName;
    private final String group;
    private final NamingService namingService;
    private final IClusterNodeManager clusterNodeManager;
    private final ClusterProperties clusterProperties;
    private Instance instance;

    public ClusterNacosNodeHandler(ClusterNacosProperties clusterNacosProperties, ClusterProperties clusterProperties, Integer port, String serviceName, IClusterNodeManager clusterNodeManager) {
        Assert.notNull((Object)serviceName, (String)"ServiceName cannot be null");
        Assert.notNull((Object)clusterNacosProperties.getGroup(), (String)"aradin.cluster.nacos.group cannot be null");
        Assert.notNull((Object)clusterNacosProperties.getServerAddr(), (String)"aradin.cluster.nacos.server-addr cannot be null");
        Assert.notNull((Object)clusterNacosProperties.getUsername(), (String)"aradin.cluster.nacos.username cannot be null");
        Assert.notNull((Object)clusterNacosProperties.getPassword(), (String)"aradin.cluster.nacos.password cannot be null");
        Assert.notNull((Object)clusterNacosProperties.getNamespace(), (String)"aradin.cluster.nacos.namespace cannot be null");
        this.serviceName = StringUtils.isNotBlank((CharSequence)clusterNacosProperties.getServiceName()) ? clusterNacosProperties.getServiceName() : serviceName;
        this.group = clusterNacosProperties.getGroup();
        this.clusterNodeManager = clusterNodeManager;
        this.clusterProperties = clusterProperties;
        Properties properties = new Properties();
        properties.put("serverAddr", clusterNacosProperties.getServerAddr());
        properties.put("username", clusterNacosProperties.getUsername());
        properties.put("password", clusterNacosProperties.getPassword());
        properties.put("namespace", clusterNacosProperties.getNamespace());
        try {
            this.namingService = NacosFactory.createNamingService((Properties)properties);
            this.namingService.subscribe(serviceName, this.group, (EventListener)this);
            if (clusterProperties.isRegister()) {
                this.register(this.group, serviceName, clusterProperties.getNodeName(), port, clusterProperties.getMaxNode(), -1);
            }
        }
        catch (NacosException e) {
            log.error("Cluster of nacos started failed, Please check your configs.");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void onEvent(Event event) {
        NamingEvent namingEvent;
        List instances;
        if (event instanceof NamingEvent && CollectionUtils.isNotEmpty((Collection)(instances = (namingEvent = (NamingEvent)event).getInstances()))) {
            HashMap<Integer, String> nodes = new HashMap<Integer, String>();
            boolean flag = false;
            for (Instance instance : instances) {
                Integer index = Integer.parseInt(instance.getClusterName());
                if (this.clusterNodeManager.currentIndex() != index.intValue()) {
                    nodes.putIfAbsent(index, instance.getIp());
                    continue;
                }
                if (!instance.getInstanceId().equals(this.clusterNodeManager.currentNode())) {
                    if (flag) continue;
                    log.warn("Found repeat node with current {}, {}. Your cluster will do reRegister immediately.", (Object)this.clusterNodeManager.currentNode(), (Object)instance.getInstanceId());
                    try {
                        this.namingService.deregisterInstance(this.serviceName, this.group, this.instance);
                    }
                    catch (NacosException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                        this.register(this.group, this.serviceName, this.instance.getInstanceId(), this.instance.getPort(), this.clusterProperties.getMaxNode(), index);
                    }
                    catch (NacosException | InterruptedException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                nodes.put(this.clusterNodeManager.currentIndex(), this.clusterNodeManager.currentNode());
                flag = true;
            }
            this.clusterNodeManager.nodeInit(nodes);
        }
    }

    private void register(String group, String serviceName, String ip, Integer port, Integer maxNode, int ignoreIndex) throws NacosException, InterruptedException {
        for (int i = 0; i < maxNode; ++i) {
            if (i == ignoreIndex) continue;
            List<String> cluster = Arrays.asList(String.valueOf(i));
            List instances = this.namingService.getAllInstances(serviceName, group, cluster, false);
            if (!CollectionUtils.isEmpty((Collection)instances)) continue;
            this.instance = new Instance();
            this.instance.setInstanceId(ip);
            this.instance.setIp(ip);
            this.instance.setPort(port.intValue());
            this.instance.setEnabled(true);
            this.instance.setHealthy(true);
            this.instance.setClusterName(String.valueOf(i));
            this.clusterNodeManager.setCurrentIndex(i);
            this.clusterNodeManager.nodeAdded(Integer.valueOf(i), ip);
            this.namingService.registerInstance(serviceName, group, this.instance);
            return;
        }
        throw new RuntimeException("OutOfNodeNum " + maxNode);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            log.warn("Cluster is deregistering.");
            this.namingService.deregisterInstance(this.serviceName, this.group, this.instance);
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }
}

