/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.cluster.core.manager;

import cn.aradin.cluster.core.manager.IClusterNodeManager;
import cn.aradin.cluster.core.properties.ClusterProperties;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DefaultClusterNodeManager
implements IClusterNodeManager {
    private Map<Integer, String> nodes = new ConcurrentHashMap<Integer, String>();
    private int currentIndex = -1;
    private ClusterProperties clusterProperties;

    public DefaultClusterNodeManager(ClusterProperties clusterProperties) {
        this.clusterProperties = clusterProperties;
    }

    @Override
    public synchronized void nodeInit(Map<Integer, String> nodes) {
        for (Integer index : nodes.keySet()) {
            this.nodes.putIfAbsent(index, nodes.get(index));
        }
    }

    @Override
    public synchronized void nodeAdded(Integer index, String node) {
        this.nodes.put(index, node);
    }

    @Override
    public synchronized void nodeRemoved(Integer index, String node) {
        String value = this.nodes.get(index);
        if (StringUtils.isNotBlank((CharSequence)value) && value.equals(node)) {
            this.nodes.remove(index);
        }
    }

    @Override
    public Integer nodeNum() {
        return this.nodes.size();
    }

    @Override
    public Collection<String> nodeNames() {
        return this.nodes.values();
    }

    @Override
    public int nodeIndex(String node) {
        for (Integer index : this.nodes.keySet()) {
            if (!this.nodes.get(index).equals(node)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int currentIndex() {
        if (StringUtils.isBlank((CharSequence)this.clusterProperties.getNodeName())) {
            throw new RuntimeException("Cluster Not Initial");
        }
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    @Override
    public String currentNode() {
        return this.clusterProperties.getNodeName();
    }
}

