/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.Sm4;
import cn.aotcloud.smcrypto.Sm4Context;
import cn.aotcloud.smcrypto.exception.InvalidContextException;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidIvException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import cn.aotcloud.smcrypto.util.ByteUtils;
import cn.aotcloud.smcrypto.util.LoggerFactory;
import cn.aotcloud.smcrypto.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class Sm4Utils {

    public static class CBC {
        private static final Logger logger = LoggerFactory.getLogger(CBC.class.getName());

        public static String encryptFromText(String plainText, String keyHex, String ivHex) throws InvalidSourceDataException, InvalidKeyException {
            return CBC.encryptFromText(plainText, keyHex, ivHex, true);
        }

        public static String encryptFromText(String plainText, String keyHex, String ivHex, boolean isPadding) throws InvalidSourceDataException, InvalidKeyException {
            if (StringUtils.isEmpty(plainText)) {
                throw new InvalidSourceDataException("[SM4_CBC:encryptFromText]invalid plainText");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromText]invalid ivHex");
            }
            byte[] plainBytes = ByteUtils.stringToBytes(plainText);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] ivBytes = ByteUtils.hexToBytes(ivHex);
            byte[] encrypted = CBC.encryptFromData(plainBytes, keyBytes, ivBytes, isPadding);
            return ByteUtils.bytesToHex(encrypted);
        }

        public static String encryptFromHex(String plainHex, String keyHex, String ivHex) throws InvalidSourceDataException, InvalidKeyException {
            return CBC.encryptFromHex(plainHex, keyHex, ivHex, true);
        }

        public static String encryptFromHex(String plainHex, String keyHex, String ivHex, boolean isPadding) throws InvalidSourceDataException, InvalidKeyException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new InvalidSourceDataException("[SM4_CBC:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromHex]invalid ivHex");
            }
            byte[] plainBytes = ByteUtils.hexToBytes(plainHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] ivBytes = ByteUtils.hexToBytes(ivHex);
            byte[] encrypted = CBC.encryptFromData(plainBytes, keyBytes, ivBytes, isPadding);
            return ByteUtils.bytesToHex(encrypted);
        }

        public static void encryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, byte[] ivBytes) throws IOException, InvalidKeyException, InvalidSourceDataException {
            CBC.encryptInputStream(is, os, keyBytes, ivBytes, true);
        }

        public static void encryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, byte[] ivBytes, boolean isPadding) throws IOException, InvalidKeyException, InvalidSourceDataException {
            int length;
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] cipherBytes = null;
            int point = 0;
            while ((length = is.read(buffer)) != -1) {
                if (point > 0 && data != null) {
                    cipherBytes = CBC.encryptFromData(data, keyBytes, ivBytes, false);
                    os.write(cipherBytes);
                }
                data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                ++point;
            }
            cipherBytes = CBC.encryptFromData(data, keyBytes, ivBytes, isPadding);
            os.write(cipherBytes);
            buffer = null;
            data = null;
            cipherBytes = null;
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes) throws InvalidSourceDataException, InvalidKeyException {
            return CBC.encryptFromData(plainBytes, keyBytes, ivBytes, true);
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes, boolean isPadding) throws InvalidSourceDataException, InvalidKeyException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new InvalidSourceDataException("[SM4_CBC:encryptFromData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new InvalidKeyException("[SM4_CBC:encryptFromData]invalid ivBytes");
            }
            try {
                Sm4Context ctx = new Sm4Context();
                ctx.isPadding = isPadding;
                Sm4 sm4 = new Sm4();
                sm4.sm4_setkey_enc(ctx, keyBytes);
                byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainBytes);
                return encrypted;
            }
            catch (InvalidContextException e) {
                logger.warning("SM4 CBC Model Encrypt InvalidContextException!");
                return null;
            }
            catch (InvalidIvException e) {
                logger.warning("SM4 CBC Model Encrypt InvalidIvException!");
                return null;
            }
            catch (IOException e) {
                logger.warning("SM4 CBC Model Encrypt IOException!");
                return null;
            }
        }

        public static String decryptToText(String cipherHex, String keyHex, String ivHex) throws InvalidCryptoDataException, InvalidKeyException {
            return CBC.decryptToText(cipherHex, keyHex, ivHex, true);
        }

        public static String decryptToText(String cipherHex, String keyHex, String ivHex, boolean isPadding) throws InvalidCryptoDataException, InvalidKeyException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new InvalidCryptoDataException("[SM4_CBC:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:decryptToText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:decryptToText]invalid ivHex");
            }
            byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] ivBytes = ByteUtils.hexToBytes(ivHex);
            byte[] decrypted = CBC.decryptToData(cipherBytes, keyBytes, ivBytes, isPadding);
            return ByteUtils.bytesToString(decrypted);
        }

        public static String decryptToHex(String cipherHex, String keyHex, String ivHex) throws InvalidCryptoDataException, InvalidKeyException {
            return CBC.decryptToHex(cipherHex, keyHex, ivHex, true);
        }

        public static String decryptToHex(String cipherHex, String keyHex, String ivHex, boolean isPadding) throws InvalidCryptoDataException, InvalidKeyException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new InvalidCryptoDataException("[SM4_CBC:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:decryptToHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new InvalidKeyException("[SM4_CBC:decryptToHex]invalid ivHex");
            }
            byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] ivBytes = ByteUtils.hexToBytes(ivHex);
            byte[] decrypted = CBC.decryptToData(cipherBytes, keyBytes, ivBytes, isPadding);
            return ByteUtils.bytesToHex(decrypted);
        }

        public static void decryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, byte[] ivBytes) throws IOException, InvalidKeyException, InvalidCryptoDataException {
            CBC.decryptInputStream(is, os, keyBytes, ivBytes, true);
        }

        public static void decryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, byte[] ivBytes, boolean isPadding) throws IOException, InvalidKeyException, InvalidCryptoDataException {
            int length;
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] plantBytes = null;
            int point = 0;
            while ((length = is.read(buffer)) != -1) {
                if (point > 0 && data != null) {
                    plantBytes = CBC.decryptToData(data, keyBytes, ivBytes, false);
                    os.write(plantBytes);
                }
                data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                ++point;
            }
            plantBytes = CBC.decryptToData(data, keyBytes, ivBytes, isPadding);
            os.write(plantBytes);
            buffer = null;
            data = null;
            plantBytes = null;
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes) throws InvalidCryptoDataException, InvalidKeyException {
            return CBC.decryptToData(cipherBytes, keyBytes, ivBytes, true);
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes, boolean isPadding) throws InvalidCryptoDataException, InvalidKeyException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new InvalidCryptoDataException("[SM4_CBC:decryptToData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new InvalidKeyException("[SM4_CBC:decryptToData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new InvalidKeyException("[SM4_CBC:decryptToData]invalid ivBytes");
            }
            try {
                Sm4Context ctx = new Sm4Context();
                ctx.isPadding = isPadding;
                Sm4 sm4 = new Sm4();
                sm4.sm4_setkey_dec(ctx, keyBytes);
                byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, cipherBytes);
                return decrypted;
            }
            catch (InvalidContextException e) {
                logger.warning("SM4 CBC Model Decrypt InvalidContextException!");
                return null;
            }
            catch (InvalidIvException e) {
                logger.warning("SM4 CBC Model Decrypt InvalidIvException!");
                return null;
            }
            catch (IOException e) {
                logger.warning("SM4 CBC Model Decrypt IOException!");
                return null;
            }
        }
    }

    public static class ECB {
        private static final Logger logger = LoggerFactory.getLogger(ECB.class.getName());

        public static String encryptFromText(String plainText, String keyHex) throws InvalidKeyException, InvalidSourceDataException {
            return ECB.encryptFromText(plainText, keyHex, true);
        }

        public static String encryptFromText(String plainText, String keyHex, boolean isPadding) throws InvalidKeyException, InvalidSourceDataException {
            if (StringUtils.isEmpty(plainText)) {
                throw new InvalidSourceDataException("[SM4_ECB:encryptFromText]invalid plainText");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_ECB:encryptFromText]invalid keyHex");
            }
            byte[] plainBytes = ByteUtils.stringToBytes(plainText);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] encrypted = ECB.encryptFromData(plainBytes, keyBytes, isPadding);
            return ByteUtils.bytesToHex(encrypted);
        }

        public static String encryptFromHex(String plainHex, String keyHex) throws InvalidKeyException, InvalidSourceDataException {
            return ECB.encryptFromHex(plainHex, keyHex, true);
        }

        public static String encryptFromHex(String plainHex, String keyHex, boolean isPadding) throws InvalidKeyException, InvalidSourceDataException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new InvalidSourceDataException("[SM4_ECB:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_ECB:encryptFromHex]invalid keyHex");
            }
            byte[] plainBytes = ByteUtils.hexToBytes(plainHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] encrypted = ECB.encryptFromData(plainBytes, keyBytes, isPadding);
            return ByteUtils.bytesToHex(encrypted);
        }

        public static void encryptInputStream(InputStream is, OutputStream os, byte[] keyBytes) throws IOException, InvalidKeyException, InvalidSourceDataException {
            ECB.encryptInputStream(is, os, keyBytes, true);
        }

        public static void encryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, boolean isPadding) throws IOException, InvalidKeyException, InvalidSourceDataException {
            int length;
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] cipherBytes = null;
            int point = 0;
            while ((length = is.read(buffer)) != -1) {
                if (point > 0 && data != null) {
                    cipherBytes = ECB.encryptFromData(data, keyBytes, false);
                    os.write(cipherBytes);
                }
                data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                ++point;
            }
            cipherBytes = ECB.encryptFromData(data, keyBytes, isPadding);
            os.write(cipherBytes);
            buffer = null;
            data = null;
            cipherBytes = null;
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes) throws InvalidKeyException, InvalidSourceDataException {
            return ECB.encryptFromData(plainBytes, keyBytes, true);
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes, boolean isPadding) throws InvalidKeyException, InvalidSourceDataException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new InvalidSourceDataException("[SM4_ECB:encryptFromData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new InvalidKeyException("[SM4_ECB:encryptFromData]invalid keyBytes");
            }
            try {
                Sm4Context ctx = new Sm4Context();
                ctx.isPadding = isPadding;
                Sm4 sm4 = new Sm4();
                sm4.sm4_setkey_enc(ctx, keyBytes);
                byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainBytes);
                return encrypted;
            }
            catch (InvalidContextException e) {
                logger.warning("SM4 ECB Model Encrypt InvalidContextException!");
                return null;
            }
            catch (IOException e) {
                logger.warning("SM4 ECB Model Encrypt IOException!");
                return null;
            }
        }

        public static String decryptToText(String cipherHex, String keyHex) throws InvalidCryptoDataException, InvalidKeyException {
            return ECB.decryptToText(cipherHex, keyHex, true);
        }

        public static String decryptToText(String cipherHex, String keyHex, boolean isPadding) throws InvalidCryptoDataException, InvalidKeyException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new InvalidCryptoDataException("[SM4_ECB:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_ECB:decryptToText]invalid keyHex");
            }
            byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] decrypted = ECB.decryptToData(cipherBytes, keyBytes, isPadding);
            return ByteUtils.bytesToString(decrypted);
        }

        public static String decryptToHex(String cipherHex, String keyHex) throws InvalidCryptoDataException, InvalidKeyException {
            return ECB.decryptToHex(cipherHex, keyHex, true);
        }

        public static String decryptToHex(String cipherHex, String keyHex, boolean isPadding) throws InvalidCryptoDataException, InvalidKeyException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new InvalidCryptoDataException("[SM4_ECB:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new InvalidKeyException("[SM4_ECB:decryptToHex]invalid keyHex");
            }
            byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
            byte[] keyBytes = ByteUtils.hexToBytes(keyHex);
            byte[] decrypted = ECB.decryptToData(cipherBytes, keyBytes, isPadding);
            return ByteUtils.bytesToHex(decrypted);
        }

        public static void decryptInputStream(InputStream is, OutputStream os, byte[] keyBytes) throws IOException, InvalidKeyException, InvalidCryptoDataException {
            ECB.decryptInputStream(is, os, keyBytes, true);
        }

        public static void decryptInputStream(InputStream is, OutputStream os, byte[] keyBytes, boolean isPadding) throws IOException, InvalidKeyException, InvalidCryptoDataException {
            int length;
            byte[] buffer = new byte[1024];
            byte[] data = null;
            byte[] plantBytes = null;
            int point = 0;
            while ((length = is.read(buffer)) != -1) {
                if (point > 0 && data != null) {
                    plantBytes = ECB.decryptToData(data, keyBytes, false);
                    os.write(plantBytes);
                }
                data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                ++point;
            }
            plantBytes = ECB.decryptToData(data, keyBytes, isPadding);
            os.write(plantBytes);
            buffer = null;
            data = null;
            plantBytes = null;
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes) throws InvalidKeyException, InvalidCryptoDataException {
            return ECB.decryptToData(cipherBytes, keyBytes, true);
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes, boolean isPadding) throws InvalidKeyException, InvalidCryptoDataException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new InvalidCryptoDataException("[SM4_ECB:decryptToData]invalid cipherBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new InvalidKeyException("[SM4_ECB:decryptToData]invalid keyBytes");
            }
            try {
                Sm4Context ctx = new Sm4Context();
                ctx.isPadding = isPadding;
                Sm4 sm4 = new Sm4();
                sm4.sm4_setkey_dec(ctx, keyBytes);
                byte[] decrypted = sm4.sm4_crypt_ecb(ctx, cipherBytes);
                return decrypted;
            }
            catch (InvalidContextException e) {
                logger.warning("SM4 ECB Model Decrypt InvalidContextException!");
                return null;
            }
            catch (IOException e) {
                logger.warning("SM4 ECB Model Decrypt IOException!");
                return null;
            }
        }
    }
}

