/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.Sm3Algorithm;

public class Sm3Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] buff = new byte[64];
    private int buffOffset = 0;
    private int blockCounter = 0;
    private byte[] digestValue = (byte[])Sm3Algorithm.DEFAULT_IV.clone();

    public Sm3Digest() {
    }

    public Sm3Digest(Sm3Digest digest) {
        System.arraycopy(digest.buff, 0, this.buff, 0, digest.buff.length);
        this.buffOffset = digest.buffOffset;
        this.blockCounter = digest.blockCounter;
        System.arraycopy(digest.digestValue, 0, this.digestValue, 0, digest.digestValue.length);
    }

    public void reset() {
        this.buff = new byte[64];
        this.buffOffset = 0;
        this.blockCounter = 0;
        this.digestValue = (byte[])Sm3Algorithm.DEFAULT_IV.clone();
    }

    public void update(byte input) {
        this.update(new byte[]{input}, 0, 1);
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void update(byte[] input, int inputOffset, int len) {
        if (input == null) {
            return;
        }
        int partLen = 64 - this.buffOffset;
        int inputLen = len;
        int dPos = inputOffset;
        if (partLen < inputLen) {
            System.arraycopy(input, dPos, this.buff, this.buffOffset, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(input, dPos, this.buff, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(input, dPos, this.buff, this.buffOffset, inputLen);
        this.buffOffset += inputLen;
    }

    private void doUpdate() {
        byte[] bytes = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.buff, i, bytes, 0, bytes.length);
            this.doHash(bytes);
        }
        this.buffOffset = 0;
    }

    private void doHash(byte[] bytes) {
        byte[] tmp = Sm3Algorithm.digestBlock(this.digestValue, bytes);
        System.arraycopy(tmp, 0, this.digestValue, 0, this.digestValue.length);
        ++this.blockCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinal(byte[] output, int offset) {
        try {
            byte[] bytes = new byte[64];
            byte[] buffer = new byte[this.buffOffset];
            System.arraycopy(this.buff, 0, buffer, 0, buffer.length);
            byte[] tmp = Sm3Algorithm.paddingBlock(buffer, this.blockCounter);
            for (int i = 0; i < tmp.length; i += 64) {
                System.arraycopy(tmp, i, bytes, 0, bytes.length);
                this.doHash(bytes);
            }
            System.arraycopy(this.digestValue, 0, output, offset, 32);
        }
        finally {
            this.reset();
        }
    }

    public byte[] doFinal() {
        byte[] result = new byte[32];
        this.doFinal(result, 0);
        return result;
    }

    public byte[] getEncrypted(byte[] password) {
        byte[] md = new byte[32];
        Sm3Digest sm3 = new Sm3Digest();
        sm3.update(password, 0, password.length);
        sm3.doFinal(md, 0);
        return md;
    }
}

