/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.util.CommonUtils;

class Sm3Algorithm {
    public static final byte[] DEFAULT_IV;
    private static int[] Tj;

    Sm3Algorithm() {
    }

    static byte[] digestBlock(byte[] V, byte[] B) {
        int[] v = Sm3Algorithm.convert(V);
        int[] b = Sm3Algorithm.convert(B);
        return Sm3Algorithm.convert(Sm3Algorithm.digestBlock(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = Sm3Algorithm.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = Sm3Algorithm.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    static int[] digestBlock(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = Sm3Algorithm.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = Sm3Algorithm.bitCycleLeft(a, 12) + e + Sm3Algorithm.bitCycleLeft(Tj[j], j);
            ss1 = Sm3Algorithm.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ Sm3Algorithm.bitCycleLeft(a, 12);
            int tt1 = Sm3Algorithm.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = Sm3Algorithm.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = Sm3Algorithm.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Sm3Algorithm.bitCycleLeft(f, 19);
            f = e;
            e = Sm3Algorithm.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (i = 16; i < 68; ++i) {
            W[i] = Sm3Algorithm.P1(W[i - 16] ^ W[i - 9] ^ Sm3Algorithm.bitCycleLeft(W[i - 3], 15)) ^ Sm3Algorithm.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return Sm3Algorithm.back(CommonUtils.intToBytes(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return CommonUtils.byteToInt(Sm3Algorithm.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return Sm3Algorithm.FF1j(X, Y, Z);
        }
        return Sm3Algorithm.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return Sm3Algorithm.GG1j(X, Y, Z);
        }
        return Sm3Algorithm.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        Sm3Algorithm.rotateLeft(X, 9);
        int y = Sm3Algorithm.bitCycleLeft(X, 9);
        Sm3Algorithm.rotateLeft(X, 17);
        int z = Sm3Algorithm.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ Sm3Algorithm.bitCycleLeft(X, 15) ^ Sm3Algorithm.bitCycleLeft(X, 23);
        return t;
    }

    static byte[] paddingBlock(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = Sm3Algorithm.back(CommonUtils.longToBytes(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    private static int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = Sm3Algorithm.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = Sm3Algorithm.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = Sm3Algorithm.bitSmall8CycleLeft(tmp, len);
        }
        return Sm3Algorithm.bigEndianByteToInt(tmp);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        for (int i = 0; i < tmp.length; ++i) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    static {
        int i;
        DEFAULT_IV = new byte[]{115, -128, 22, 111, 73, 20, -78, -71, 23, 36, 66, -41, -38, -118, 6, 0, -87, 111, 48, -68, 22, 49, 56, -86, -29, -115, -18, 77, -80, -5, 14, 78};
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            Sm3Algorithm.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            Sm3Algorithm.Tj[i] = 2055708042;
        }
    }
}

