/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.CipherMode;
import cn.aotcloud.smcrypto.Sm2Cipher;
import cn.aotcloud.smcrypto.Sm2KeyPair;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSignDataException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import cn.aotcloud.smcrypto.util.ByteUtils;
import cn.aotcloud.smcrypto.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Sm2Utils {
    private CipherMode cipherMode = CipherMode.C1C2C3;
    private String randomKeyHex = null;
    private static final List<Integer> keyHexLenList = Arrays.asList(60, 62, 64, 66, 68, 128);
    private static final List<Integer> keyByteLenList = Arrays.asList(30, 31, 32, 33, 34, 64);

    public Sm2Utils() {
        this.cipherMode = CipherMode.C1C2C3;
    }

    public Sm2Utils(CipherMode cipherMode) {
        this.cipherMode = cipherMode;
    }

    public Sm2Utils(CipherMode cipherMode, String randomKeyHex) {
        this.cipherMode = cipherMode;
        this.randomKeyHex = randomKeyHex;
    }

    public String[] generateKeyPair() {
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        Sm2KeyPair keyPair = sm2Cipher.generateKeyPair();
        return new String[]{ByteUtils.bytesToHex(keyPair.getPrivateKey()), ByteUtils.bytesToHex(keyPair.getPublicKey())};
    }

    public String getPublicKey(String prvKeyHex) {
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        byte[] publicKey = sm2Cipher.getPublicKey(ByteUtils.hexToBytes(prvKeyHex));
        return ByteUtils.bytesToHex(publicKey);
    }

    public String encryptFromText(String pubKeyHex, String sourceText) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:encryptFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromText]invalid sourceText");
        }
        if (StringUtils.length(pubKeyHex) < 130 && !pubKeyHex.startsWith("04")) {
            pubKeyHex = "04" + pubKeyHex;
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] dataBytes = this.encryptFromData(pubKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(dataBytes);
    }

    public String encryptFromHex(String pubKeyHex, String sourceHex) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:encryptFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromHex]invalid sourceHex");
        }
        if (pubKeyHex.length() < 130 && !pubKeyHex.startsWith("04")) {
            pubKeyHex = "04" + pubKeyHex;
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] dataBytes = this.encryptFromData(pubKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(dataBytes);
    }

    public byte[] encryptFromData(byte[] pubKeyBytes, byte[] sourceBytes) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new InvalidKeyException("[SM2:encryptFromBytes]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:encryptFromBytes]invalid sourceBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher(this.cipherMode, this.randomKeyHex);
        return sm2Cipher.encrypt(pubKeyBytes, sourceBytes);
    }

    public String decryptToText(String prvKeyHex, String cipherHex) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:decryptToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new InvalidCryptoDataException("[SM2:decryptToText]invalid cipherHex");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
        byte[] sourceBytes = this.decryptToData(prvKeyBytes, cipherBytes);
        return ByteUtils.bytesToString(sourceBytes);
    }

    public String decryptToHex(String prvKeyHex, String cipherHex) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:decryptToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new InvalidCryptoDataException("[SM2:decryptToHex]invalid cipherHex");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
        byte[] sourceBytes = this.decryptToData(prvKeyBytes, cipherBytes);
        return ByteUtils.bytesToHex(sourceBytes);
    }

    public byte[] decryptToData(byte[] prvKeyBytes, byte[] cipherBytes) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new InvalidKeyException("[SM2:decryptToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(cipherBytes)) {
            throw new InvalidCryptoDataException("[SM2:decryptToData]invalid cipherBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher(this.cipherMode, this.randomKeyHex);
        return sm2Cipher.decrypt(prvKeyBytes, cipherBytes);
    }

    public String encryptASN1FromText(String pubKeyHex, String sourceText) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromText]invalid sourceText");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] dataBytes = this.encryptASN1FromData(pubKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(dataBytes);
    }

    public String encryptASN1FromHex(String pubKeyHex, String sourceHex) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromHex]invalid sourceText");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] dataBytes = this.encryptASN1FromData(pubKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(dataBytes);
    }

    public byte[] encryptASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new InvalidKeyException("[SM2:encryptASN1FromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:encryptASN1FromData]invalid sourceBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher(CipherMode.C1C3C2, this.randomKeyHex);
        return sm2Cipher.encryptToASN1(pubKeyBytes, sourceBytes);
    }

    public String decryptASN1ToText(String prvKeyHex, String cipherHex) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToText]invalid cipherHex");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
        byte[] sourceBytes = this.decryptASN1ToData(prvKeyBytes, cipherBytes);
        return ByteUtils.bytesToString(sourceBytes);
    }

    public String decryptASN1ToHex(String prvKeyHex, String cipherHex) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToHex]invalid cipherHex");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] cipherBytes = ByteUtils.hexToBytes(cipherHex);
        byte[] sourceBytes = this.decryptASN1ToData(prvKeyBytes, cipherBytes);
        return ByteUtils.bytesToHex(sourceBytes);
    }

    public byte[] decryptASN1ToData(byte[] prvKeyBytes, byte[] cipherBytes) throws InvalidKeyException, InvalidCryptoDataException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new InvalidKeyException("[SM2:decryptASN1ToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(cipherBytes)) {
            throw new InvalidCryptoDataException("[SM2:decryptASN1ToData]invalid cipherBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher(CipherMode.C1C3C2, this.randomKeyHex);
        return sm2Cipher.decryptFromASN1(prvKeyBytes, cipherBytes);
    }

    public String signFromText(String prvKeyHex, String sourceText) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromText]invalid sourceText");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] signBytes = this.signFromData(prvKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(signBytes);
    }

    public String signFromHex(String prvKeyHex, String sourceHex) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromHex]invalid sourceText");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] signBytes = this.signFromData(prvKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(signBytes);
    }

    public byte[] signFromData(byte[] prvKeyBytes, byte[] sourceBytes) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new InvalidKeyException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:signFromData]invalid sourceBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        return sm2Cipher.sign(prvKeyBytes, sourceBytes);
    }

    public boolean verifySignFromText(String pubKeyHex, String sourceText, String signHex) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] signBytes = ByteUtils.hexToBytes(signHex);
        return this.verifySignFromData(pubKeyBytes, sourceBytes, signBytes);
    }

    public boolean verifySignFromHex(String pubKeyHex, String sourceHex, String signHex) throws InvalidKeyException, InvalidSourceDataException, InvalidSignDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] signBytes = ByteUtils.hexToBytes(signHex);
        return this.verifySignFromData(pubKeyBytes, sourceBytes, signBytes);
    }

    public boolean verifySignFromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new InvalidKeyException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (signBytes == null || signBytes.length != 64) {
            throw new InvalidSignDataException("[SM2:verifySignFromData]invalid signBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        return sm2Cipher.verifySign(pubKeyBytes, sourceBytes, signBytes);
    }

    public String signASN1FromText(String prvKeyHex, String sourceText) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromText]invalid sourceText");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] signBytes = this.signASN1FromData(prvKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(signBytes);
    }

    public String signASN1FromHex(String prvKeyHex, String sourceHex) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyHex)) {
            throw new InvalidKeyException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:signFromHex]invalid sourceText");
        }
        byte[] prvKeyBytes = ByteUtils.hexToBytes(prvKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] signBytes = this.signASN1FromData(prvKeyBytes, sourceBytes);
        return ByteUtils.bytesToHex(signBytes);
    }

    public byte[] signASN1FromData(byte[] prvKeyBytes, byte[] sourceBytes) throws InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new InvalidKeyException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:signFromData]invalid sourceBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        return sm2Cipher.signToASN1(prvKeyBytes, sourceBytes);
    }

    public boolean verifySignASN1FromText(String pubKeyHex, String sourceText, String signHex) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.stringToBytes(sourceText);
        byte[] signBytes = ByteUtils.hexToBytes(signHex);
        return this.verifySignASN1FromData(pubKeyBytes, sourceBytes, signBytes);
    }

    public boolean verifySignASN1FromHex(String pubKeyHex, String sourceHex, String signHex) throws InvalidKeyException, InvalidSourceDataException, InvalidSignDataException {
        if (this.invalidKey(pubKeyHex)) {
            throw new InvalidKeyException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromHex]invalid signHex");
        }
        byte[] pubKeyBytes = ByteUtils.hexToBytes(pubKeyHex);
        byte[] sourceBytes = ByteUtils.hexToBytes(sourceHex);
        byte[] signBytes = ByteUtils.hexToBytes(signHex);
        return this.verifySignASN1FromData(pubKeyBytes, sourceBytes, signBytes);
    }

    public boolean verifySignASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes) throws InvalidSignDataException, InvalidKeyException, InvalidSourceDataException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new InvalidKeyException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new InvalidSourceDataException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (signBytes == null || signBytes.length == 0) {
            throw new InvalidSignDataException("[SM2:verifySignFromData]invalid signBytes");
        }
        Sm2Cipher sm2Cipher = new Sm2Cipher();
        return sm2Cipher.verifySignByASN1(pubKeyBytes, sourceBytes, signBytes);
    }

    private final boolean invalidKey(Object keyObj) {
        if (keyObj == null) {
            return true;
        }
        if (keyObj instanceof String) {
            String keyString = (String)keyObj;
            int keyLength = keyString.length();
            if (keyLength == 130 && keyString.startsWith("04")) {
                return false;
            }
            return !keyHexLenList.contains(keyLength);
        }
        if (keyObj instanceof byte[]) {
            byte[] keyBytes = (byte[])keyObj;
            if (keyBytes.length == 65 && keyBytes[0] == 4) {
                return false;
            }
            return !keyByteLenList.contains(keyBytes.length);
        }
        return true;
    }

    private final boolean invalidCipherObj(Object cipherObj) {
        if (cipherObj == null) {
            return true;
        }
        if (cipherObj instanceof String) {
            String cipherHex = (String)cipherObj;
            int cipherLength = cipherHex.length();
            return cipherLength < 196 || cipherLength % 2 == 1;
        }
        if (cipherObj instanceof byte[]) {
            byte[] cipherBytes = (byte[])cipherObj;
            return cipherBytes.length < 98;
        }
        return true;
    }
}

