/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.CipherMode;
import cn.aotcloud.smcrypto.Sm2KeyPair;
import cn.aotcloud.smcrypto.Sm3Digest;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidCryptoParamsException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSignDataException;
import cn.aotcloud.smcrypto.util.ByteUtils;
import cn.aotcloud.smcrypto.util.CommonUtils;
import cn.aotcloud.smcrypto.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class Sm2Cipher {
    private static final BigInteger SM2_ECC_P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger SM2_ECC_A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static final BigInteger SM2_ECC_B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static final BigInteger SM2_ECC_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final byte[] DEFAULT_USER_ID = "1234567812345678".getBytes();
    private ECCurve curve;
    private ECPoint pointG;
    private ECKeyPairGenerator keyPairGenerator;
    private CipherMode cipherMode;
    private ECPoint alternateKeyPoint;
    private Sm3Digest alternateKeyDigest;
    private Sm3Digest c3Digest;
    private int alternateKeyCount;
    private byte[] alternateKey;
    private byte alternateKeyOff;
    private String randomKeyHex;

    public Sm2Cipher() {
        this(CipherMode.C1C2C3);
    }

    public Sm2Cipher(CipherMode cipherMode) {
        this(new SecureRandom(), cipherMode);
    }

    public Sm2Cipher(CipherMode cipherMode, String randomKeyHex) {
        this(new SecureRandom(), cipherMode);
        this.randomKeyHex = randomKeyHex;
    }

    private Sm2Cipher(SecureRandom secureRandom, CipherMode cipherMode) {
        this(secureRandom, cipherMode, SM2_ECC_P, SM2_ECC_A, SM2_ECC_B, SM2_ECC_N, SM2_ECC_GX, SM2_ECC_GY);
    }

    private Sm2Cipher(SecureRandom secureRandom, CipherMode cipherMode, BigInteger eccP, BigInteger eccA, BigInteger eccB, BigInteger eccN, BigInteger eccGx, BigInteger eccGy) {
        if (eccP == null || eccA == null || eccB == null || eccN == null || eccGx == null || eccGy == null) {
            throw new InvalidCryptoParamsException("[SM2]ecc params of the SM2Cipher is null");
        }
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.cipherMode = cipherMode;
        ECFieldElement.Fp gxFieldElement = new ECFieldElement.Fp(eccP, eccGx);
        ECFieldElement.Fp gyFieldElement = new ECFieldElement.Fp(eccP, eccGy);
        this.curve = new ECCurve.Fp(eccP, eccA, eccB);
        this.pointG = this.curve.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        ECDomainParameters domainParams = new ECDomainParameters(this.curve, this.pointG, eccN);
        ECKeyGenerationParameters keyGenerationParams = new ECKeyGenerationParameters(domainParams, secureRandom);
        this.keyPairGenerator = new ECKeyPairGenerator();
        this.keyPairGenerator.init((KeyGenerationParameters)keyGenerationParams);
    }

    private final void resetKey() {
        this.alternateKeyDigest = new Sm3Digest();
        this.c3Digest = new Sm3Digest();
        byte[] x = CommonUtils.byteConvert32Bytes(this.alternateKeyPoint.normalize().getXCoord().toBigInteger());
        byte[] y = CommonUtils.byteConvert32Bytes(this.alternateKeyPoint.normalize().getYCoord().toBigInteger());
        this.c3Digest.update(x, 0, x.length);
        this.alternateKeyDigest.update(x);
        this.alternateKeyDigest.update(y);
        this.alternateKeyCount = 1;
        this.nextKey();
    }

    private final void nextKey() {
        Sm3Digest digest = new Sm3Digest(this.alternateKeyDigest);
        digest.update((byte)(this.alternateKeyCount >> 24 & 0xFF));
        digest.update((byte)(this.alternateKeyCount >> 16 & 0xFF));
        digest.update((byte)(this.alternateKeyCount >> 8 & 0xFF));
        digest.update((byte)(this.alternateKeyCount & 0xFF));
        this.alternateKey = digest.doFinal();
        this.alternateKeyOff = 0;
        ++this.alternateKeyCount;
    }

    private final byte[] getZ(byte[] userId, ECPoint userKey) {
        Sm3Digest digest = new Sm3Digest();
        if (userId == null) {
            userId = DEFAULT_USER_ID;
        }
        int len = userId.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userId);
        byte[] p = CommonUtils.byteConvert32Bytes(SM2_ECC_A);
        digest.update(p);
        p = CommonUtils.byteConvert32Bytes(SM2_ECC_B);
        digest.update(p);
        p = CommonUtils.byteConvert32Bytes(SM2_ECC_GX);
        digest.update(p);
        p = CommonUtils.byteConvert32Bytes(SM2_ECC_GY);
        digest.update(p);
        p = CommonUtils.byteConvert32Bytes(userKey.normalize().getXCoord().toBigInteger());
        digest.update(p);
        p = CommonUtils.byteConvert32Bytes(userKey.normalize().getYCoord().toBigInteger());
        digest.update(p);
        return digest.doFinal();
    }

    public final Sm2KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters privateKeyParams = (ECPrivateKeyParameters)keyPair.getPrivate();
        ECPublicKeyParameters publicKeyParams = (ECPublicKeyParameters)keyPair.getPublic();
        BigInteger privateKey = privateKeyParams.getD();
        ECPoint publicKey = publicKeyParams.getQ();
        return new Sm2KeyPair(privateKey.toByteArray(), publicKey.getEncoded(false));
    }

    public byte[] getPublicKey(byte[] privateKey) {
        ECDomainParameters domainParams = new ECDomainParameters(this.curve, this.pointG, SM2_ECC_N);
        BigInteger d = new BigInteger(privateKey);
        ECPoint Q = domainParams.getG().multiply(d);
        return Q.getEncoded(false);
    }

    public final byte[] encrypt(byte[] pubKeyBytes, byte[] dataBytes) throws InvalidKeyException {
        Sm2EncryptedData encryptedData = this.encryptInner(pubKeyBytes, dataBytes);
        if (encryptedData == null) {
            return null;
        }
        ECPoint c1 = encryptedData.getC1();
        byte[] c2 = encryptedData.getC2();
        byte[] c3 = encryptedData.getC3();
        String encHex = null;
        switch (this.cipherMode) {
            case C1C2C3: {
                encHex = ByteUtils.bytesToHex(c1.getEncoded(false)) + ByteUtils.bytesToHex(c2) + ByteUtils.bytesToHex(c3);
                break;
            }
            case C1C3C2: {
                encHex = ByteUtils.bytesToHex(c1.getEncoded(false)) + ByteUtils.bytesToHex(c3) + ByteUtils.bytesToHex(c2);
                break;
            }
            default: {
                throw new InvalidCryptoParamsException("[SM2:Encrypt]invalid type(" + String.valueOf((Object)this.cipherMode) + ")");
            }
        }
        return ByteUtils.hexToBytes(encHex);
    }

    public final byte[] encryptToASN1(byte[] pubKeyBytes, byte[] data) throws InvalidKeyException {
        Sm2EncryptedData encryptedData = this.encryptInner(pubKeyBytes, data);
        if (encryptedData == null) {
            return null;
        }
        ECPoint c1 = encryptedData.getC1();
        byte[] c2 = encryptedData.getC2();
        byte[] c3 = encryptedData.getC3();
        ASN1Integer x = new ASN1Integer(c1.normalize().getXCoord().toBigInteger());
        ASN1Integer y = new ASN1Integer(c1.normalize().getYCoord().toBigInteger());
        DEROctetString derC2 = new DEROctetString(c2);
        DEROctetString derC3 = new DEROctetString(c3);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)x);
        vector.add((ASN1Encodable)y);
        switch (this.cipherMode) {
            case C1C2C3: {
                vector.add((ASN1Encodable)derC2);
                vector.add((ASN1Encodable)derC3);
                break;
            }
            case C1C3C2: {
                vector.add((ASN1Encodable)derC3);
                vector.add((ASN1Encodable)derC2);
                break;
            }
            default: {
                throw new InvalidCryptoParamsException("[SM2:EncryptASN1]invalid type(" + String.valueOf((Object)this.cipherMode) + ")");
            }
        }
        DERSequence seq = new DERSequence(vector);
        try {
            return seq.getEncoded("DER");
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid DEROutputStream");
        }
    }

    protected final Sm2EncryptedData encryptInner(byte[] pubKeyBytes, byte[] data) throws InvalidKeyException {
        ECPoint keyPoint;
        if (pubKeyBytes == null || pubKeyBytes.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:Encrypt]key is null");
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] c2 = new byte[data.length];
        System.arraycopy(data, 0, c2, 0, data.length);
        try {
            keyPoint = this.curve.decodePoint(pubKeyBytes);
        }
        catch (Exception e) {
            throw new InvalidKeyException("[SM2:Encrypt]invalid key data(format)", e);
        }
        AsymmetricCipherKeyPair generatedKey = this.randomKeyHex == null ? this.keyPairGenerator.generateKeyPair() : this.generateKeyPair(this.randomKeyHex);
        ECPrivateKeyParameters privateKeyParams = (ECPrivateKeyParameters)generatedKey.getPrivate();
        ECPublicKeyParameters publicKeyParams = (ECPublicKeyParameters)generatedKey.getPublic();
        BigInteger privateKey = privateKeyParams.getD();
        ECPoint c1 = publicKeyParams.getQ();
        this.alternateKeyPoint = keyPoint.multiply(privateKey);
        this.resetKey();
        this.c3Digest.update(c2);
        int i = 0;
        while (i < c2.length) {
            if (this.alternateKeyOff >= this.alternateKey.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.alternateKeyOff;
            this.alternateKeyOff = (byte)(by + 1);
            c2[n] = (byte)(c2[n] ^ this.alternateKey[by]);
        }
        byte[] p = CommonUtils.byteConvert32Bytes(this.alternateKeyPoint.normalize().getYCoord().toBigInteger());
        this.c3Digest.update(p);
        byte[] c3 = this.c3Digest.doFinal();
        this.resetKey();
        return new Sm2EncryptedData(c1, c2, c3);
    }

    @Deprecated
    protected AsymmetricCipherKeyPair generateKeyPair(String randomKeyHex) {
        ECDomainParameters domainParams = new ECDomainParameters(this.curve, this.pointG, SM2_ECC_N);
        BigInteger n = domainParams.getN();
        BigInteger d = new BigInteger(randomKeyHex, 16);
        if (d.equals(BigInteger.valueOf(0L)) || d.compareTo(n) >= 0) {
            throw new InvalidCryptoParamsException("[SM2:generateKeyPair]invalid randomKeyData, random D mast be greater than Param N");
        }
        ECPoint Q = domainParams.getG().multiply(d);
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(Q, domainParams), (AsymmetricKeyParameter)new ECPrivateKeyParameters(d, domainParams));
    }

    public final byte[] decrypt(byte[] prvKeyBytes, byte[] dataBytes) throws InvalidKeyException, InvalidCryptoDataException {
        if (prvKeyBytes == null || prvKeyBytes.length == 0) {
            return null;
        }
        if (dataBytes == null || dataBytes.length == 0) {
            return null;
        }
        String data = ByteUtils.bytesToHex(dataBytes);
        int datLength = data.length();
        byte[] c1Bytes = ByteUtils.hexToBytes(data.substring(0, 130));
        int c2Len = 0;
        byte[] c2 = null;
        byte[] c3 = null;
        switch (this.cipherMode) {
            case C1C2C3: {
                c2Len = dataBytes.length - 97;
                c2 = ByteUtils.hexToBytes(data.substring(130, 130 + 2 * c2Len));
                c3 = ByteUtils.hexToBytes(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
                return this.decryptInner(prvKeyBytes, c1Bytes, c2, c3);
            }
            case C1C3C2: {
                c3 = ByteUtils.hexToBytes(data.substring(130, 194));
                c2 = ByteUtils.hexToBytes(data.substring(194, datLength));
                return this.decryptInner(prvKeyBytes, c1Bytes, c2, c3);
            }
        }
        throw new InvalidCryptoParamsException("[SM2:Encrypt]invalid type(" + String.valueOf((Object)this.cipherMode) + ")");
    }

    public final byte[] decryptFromASN1(byte[] prvKeyBytes, byte[] data) throws InvalidKeyException, InvalidCryptoDataException {
        byte[] c3;
        byte[] c2;
        ECPoint c1;
        ASN1Primitive derObj;
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        try {
            derObj = asn1InputStream.readObject();
            ASN1Primitive endObj = asn1InputStream.readObject();
            if (endObj != null) {
                throw new InvalidCryptoDataException("[SM2:decrypt:ASN1]invalid encrypted data");
            }
        }
        catch (IOException e) {
            throw new InvalidCryptoDataException("[SM2:decrypt:ASN1]invalid encrypted data", e);
        }
        finally {
            IOUtils.closeQuietly(byteArrayInputStream);
            IOUtils.closeQuietly((InputStream)asn1InputStream);
        }
        ASN1Sequence asn1 = (ASN1Sequence)derObj;
        ASN1Integer x = (ASN1Integer)asn1.getObjectAt(0);
        ASN1Integer y = (ASN1Integer)asn1.getObjectAt(1);
        try {
            c1 = this.curve.createPoint(x.getValue(), y.getValue());
        }
        catch (Exception e) {
            throw new InvalidCryptoDataException("[SM2:decrypt:ASN1]invalid encrypted data, c1", e);
        }
        switch (this.cipherMode) {
            case C1C2C3: {
                c2 = ((DEROctetString)asn1.getObjectAt(2)).getOctets();
                c3 = ((DEROctetString)asn1.getObjectAt(3)).getOctets();
                break;
            }
            case C1C3C2: {
                c3 = ((DEROctetString)asn1.getObjectAt(2)).getOctets();
                c2 = ((DEROctetString)asn1.getObjectAt(3)).getOctets();
                break;
            }
            default: {
                throw new InvalidCryptoParamsException("[SM2:Decrypt:ASN1]invalid type(" + String.valueOf((Object)this.cipherMode) + ")");
            }
        }
        return this.decryptInner(prvKeyBytes, c1.getEncoded(false), c2, c3);
    }

    private final byte[] decryptInner(byte[] prvKeyBytes, byte[] c1, byte[] c2, byte[] c3) throws InvalidKeyException, InvalidCryptoDataException {
        ECPoint c1Point;
        if (prvKeyBytes == null || prvKeyBytes.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:Decrypt]key is null");
        }
        if (c1 == null || c1.length <= 0 || c2 == null || c2.length <= 0 || c3 == null || c3.length <= 0) {
            throw new InvalidCryptoDataException("[SM2:Decrypt]invalid encrypt data, c1 / c2 / c3 is null or empty");
        }
        BigInteger decryptKey = new BigInteger(1, prvKeyBytes);
        try {
            c1Point = this.curve.decodePoint(c1);
        }
        catch (Exception e) {
            throw new InvalidCryptoDataException("[SM2:Decrypt]invalid encrypt data, c1 invalid", e);
        }
        this.alternateKeyPoint = c1Point.multiply(decryptKey);
        this.resetKey();
        int i = 0;
        while (i < c2.length) {
            if (this.alternateKeyOff >= this.alternateKey.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.alternateKeyOff;
            this.alternateKeyOff = (byte)(by + 1);
            c2[n] = (byte)(c2[n] ^ this.alternateKey[by]);
        }
        this.c3Digest.update(c2, 0, c2.length);
        byte[] p = CommonUtils.byteConvert32Bytes(this.alternateKeyPoint.normalize().getYCoord().toBigInteger());
        this.c3Digest.update(p, 0, p.length);
        byte[] verifyC3 = this.c3Digest.doFinal();
        if (!Arrays.equals(verifyC3, c3)) {
            throw new InvalidKeyException("[SM2:Decrypt]invalid key, c3 is not match");
        }
        this.resetKey();
        return c2;
    }

    private final BigInteger[] sign(byte[] userId, byte[] prvKeyBytes, byte[] sourceData) {
        if (prvKeyBytes == null || prvKeyBytes.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:sign]prvKeyBytes is null");
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:sign]sourceData is null");
        }
        BigInteger key = new BigInteger(prvKeyBytes);
        ECPoint keyPoint = this.pointG.multiply(key);
        Sm3Digest digest = new Sm3Digest();
        byte[] z = this.getZ(userId, keyPoint);
        digest.update(z, 0, z.length);
        digest.update(sourceData);
        byte[] digestData = digest.doFinal();
        return this.signInner(digestData, key, keyPoint);
    }

    public final byte[] sign(byte[] prvKeyBytes, byte[] sourceData) {
        BigInteger[] bigIntegers = this.sign(DEFAULT_USER_ID, prvKeyBytes, sourceData);
        byte[] rBytes = Sm2Cipher.modifyRSFixedBytes(bigIntegers[0].toByteArray());
        byte[] sBytes = Sm2Cipher.modifyRSFixedBytes(bigIntegers[1].toByteArray());
        byte[] signBytes = new byte[rBytes.length + sBytes.length];
        System.arraycopy(rBytes, 0, signBytes, 0, rBytes.length);
        System.arraycopy(sBytes, 0, signBytes, rBytes.length, sBytes.length);
        return signBytes;
    }

    private static byte[] modifyRSFixedBytes(byte[] rs) {
        int length = rs.length;
        int fixedLength = 32;
        byte[] result = new byte[fixedLength];
        if (length < 32) {
            System.arraycopy(rs, 0, result, fixedLength - length, length);
        } else {
            System.arraycopy(rs, length - fixedLength, result, 0, fixedLength);
        }
        return result;
    }

    protected final byte[] signToASN1(byte[] userId, byte[] prvKeyBytes, byte[] sourceData) {
        if (prvKeyBytes == null || prvKeyBytes.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:signToASN1]prvKeyBytes is null");
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:signToASN1]sourceData is null");
        }
        BigInteger[] signData = this.sign(userId, prvKeyBytes, sourceData);
        ASN1Integer derR = new ASN1Integer(signData[0]);
        ASN1Integer derS = new ASN1Integer(signData[1]);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)derR);
        vector.add((ASN1Encodable)derS);
        DERSequence sign = new DERSequence(vector);
        try {
            return sign.getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public final byte[] signToASN1(byte[] prvKeyBytes, byte[] sourceData) {
        return this.signToASN1(DEFAULT_USER_ID, prvKeyBytes, sourceData);
    }

    private final BigInteger[] signInner(byte[] digestData, BigInteger key, ECPoint keyPoint) {
        BigInteger s;
        BigInteger r;
        BigInteger e = new BigInteger(1, digestData);
        while (true) {
            AsymmetricCipherKeyPair keypair = this.keyPairGenerator.generateKeyPair();
            ECPrivateKeyParameters privateKey = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters publicKey = (ECPublicKeyParameters)keypair.getPublic();
            BigInteger k = privateKey.getD();
            ECPoint kp = publicKey.getQ();
            r = e.add(kp.normalize().getXCoord().toBigInteger());
            if ((r = r.mod(SM2_ECC_N)).equals(BigInteger.ZERO) || r.add(k).equals(SM2_ECC_N)) continue;
            BigInteger da_1 = key.add(BigInteger.ONE);
            da_1 = da_1.modInverse(SM2_ECC_N);
            s = r.multiply(key);
            s = k.subtract(s).mod(SM2_ECC_N);
            if (!(s = da_1.multiply(s).mod(SM2_ECC_N)).equals(BigInteger.ZERO)) break;
        }
        return new BigInteger[]{r, s};
    }

    private final boolean verifySign(byte[] userId, byte[] pubKeyBytes, byte[] sourceData, BigInteger signR, BigInteger signS) throws InvalidKeyException {
        ECPoint key;
        if (pubKeyBytes == null || pubKeyBytes.length == 0) {
            throw new InvalidCryptoParamsException("[SM2:verifySign]key is null");
        }
        if (sourceData == null || sourceData.length == 0 || signR == null || signS == null) {
            return false;
        }
        try {
            key = this.curve.decodePoint(pubKeyBytes);
        }
        catch (Exception e) {
            throw new InvalidKeyException("[SM2:verifySign]invalid public key (format)", e);
        }
        Sm3Digest digest = new Sm3Digest();
        byte[] z = this.getZ(userId, key);
        digest.update(z, 0, z.length);
        digest.update(sourceData, 0, sourceData.length);
        byte[] digestData = digest.doFinal();
        return signR.equals(this.verifyInner(digestData, key, signR, signS));
    }

    public final boolean verifySign(byte[] pubKeyBytes, byte[] sourceData, byte[] signData) throws InvalidSignDataException, InvalidKeyException {
        BigInteger R = null;
        BigInteger S = null;
        byte[] rBy = new byte[33];
        System.arraycopy(signData, 0, rBy, 1, 32);
        rBy[0] = 0;
        byte[] sBy = new byte[33];
        System.arraycopy(signData, 32, sBy, 1, 32);
        sBy[0] = 0;
        R = new BigInteger(rBy);
        S = new BigInteger(sBy);
        return this.verifySign(DEFAULT_USER_ID, pubKeyBytes, sourceData, R, S);
    }

    protected final boolean verifySignByASN1(byte[] userId, byte[] pubKeyBytes, byte[] sourceData, byte[] signData) throws InvalidSignDataException, InvalidKeyException {
        Enumeration signObj;
        byte[] _signData = signData;
        int startIndex = 0;
        for (int i = 0; i < signData.length && signData[i] == 0; ++i) {
            ++startIndex;
        }
        if (startIndex > 0) {
            _signData = new byte[signData.length - startIndex];
            System.arraycopy(signData, startIndex, _signData, 0, _signData.length);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_signData);
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        try {
            ASN1Primitive derObj = asn1InputStream.readObject();
            ASN1Primitive endObj = asn1InputStream.readObject();
            if (endObj != null) {
                throw new InvalidSignDataException("[SM2:decrypt:ASN1]invalid sign data (ASN.1)");
            }
            signObj = ((ASN1Sequence)derObj).getObjects();
        }
        catch (IOException e) {
            throw new InvalidSignDataException("[SM2:verifySign]invalid sign data (ASN.1)", e);
        }
        finally {
            IOUtils.closeQuietly(byteArrayInputStream);
            IOUtils.closeQuietly((InputStream)asn1InputStream);
        }
        BigInteger r = ((ASN1Integer)signObj.nextElement()).getValue();
        BigInteger s = ((ASN1Integer)signObj.nextElement()).getValue();
        return this.verifySign(userId, pubKeyBytes, sourceData, r, s);
    }

    public final boolean verifySignByASN1(byte[] pubKeyBytes, byte[] sourceData, byte[] signData) throws InvalidSignDataException, InvalidKeyException {
        return this.verifySignByASN1(DEFAULT_USER_ID, pubKeyBytes, sourceData, signData);
    }

    private final BigInteger verifyInner(byte[] digestData, ECPoint userKey, BigInteger r, BigInteger s) {
        BigInteger e = new BigInteger(1, digestData);
        BigInteger t = r.add(s).mod(SM2_ECC_N);
        if (t.equals(BigInteger.ZERO)) {
            return null;
        }
        ECPoint x1y1 = this.pointG.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        return e.add(x1y1.normalize().getXCoord().toBigInteger()).mod(SM2_ECC_N);
    }

    class Sm2EncryptedData {
        private ECPoint c1;
        private byte[] c2;
        private byte[] c3;

        public Sm2EncryptedData(ECPoint c1, byte[] c2, byte[] c3) {
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        public ECPoint getC1() {
            return this.c1;
        }

        public void setC1(ECPoint c1) {
            this.c1 = c1;
        }

        public byte[] getC2() {
            return this.c2;
        }

        public void setC2(byte[] c2) {
            this.c2 = c2;
        }

        public byte[] getC3() {
            return this.c3;
        }

        public void setC3(byte[] c3) {
            this.c3 = c3;
        }
    }
}

