/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.gmcrypto;

import cn.aotcloud.gmcrypto.util.ByteUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmCryptoNativeUtil {
    private static final Logger logger = LoggerFactory.getLogger(GmCryptoNativeUtil.class);

    public native String getVersion();

    public native String[] generateKeyPair();

    public native String getPublicKey(String var1);

    public native byte[] sm3EncryptFromData(byte[] var1);

    public native String sm3EncryptFromHex(String var1);

    public native String sm3EncryptFromText(String var1);

    public native byte[] sm4EcbEncryptFromData(byte[] var1, byte[] var2);

    public native byte[] sm4EcbDecryptToData(byte[] var1, byte[] var2);

    public native String sm4EcbEncryptFromHex(String var1, String var2);

    public native String sm4EcbDecryptToHex(String var1, String var2);

    public native String sm4EcbEncryptFromText(String var1, String var2);

    public native String sm4EcbDecryptToText(String var1, String var2);

    public native byte[] sm4CbcEncryptFromData(byte[] var1, byte[] var2, byte[] var3);

    public native byte[] sm4CbcDecryptToData(byte[] var1, byte[] var2, byte[] var3);

    public native String sm4CbcEncryptFromHex(String var1, String var2, String var3);

    public native String sm4CbcDecryptToHex(String var1, String var2, String var3);

    public native String sm4CbcEncryptFromText(String var1, String var2, String var3);

    public native String sm4CbcDecryptToText(String var1, String var2, String var3);

    public native byte[] sm4EcbNoPaddingEncryptFromData(byte[] var1, byte[] var2);

    public native byte[] sm4EcbNoPaddingDecryptToData(byte[] var1, byte[] var2);

    public native String sm4EcbNoPaddingEncryptFromHex(String var1, String var2);

    public native String sm4EcbNoPaddingDecryptToHex(String var1, String var2);

    public native String sm4EcbNoPaddingEncryptFromText(String var1, String var2);

    public native String sm4EcbNoPaddingDecryptToText(String var1, String var2);

    public native byte[] sm4CbcNoPaddingEncryptFromData(byte[] var1, byte[] var2, byte[] var3);

    public native byte[] sm4CbcNoPaddingDecryptToData(byte[] var1, byte[] var2, byte[] var3);

    public native String sm4CbcNoPaddingEncryptFromHex(String var1, String var2, String var3);

    public native String sm4CbcNoPaddingDecryptToHex(String var1, String var2, String var3);

    public native String sm4CbcNoPaddingEncryptFromText(String var1, String var2, String var3);

    public native String sm4CbcNoPaddingDecryptToText(String var1, String var2, String var3);

    public native byte[] sm2EncryptFromData(int var1, byte[] var2, byte[] var3);

    public native byte[] sm2DecryptToData(int var1, byte[] var2, byte[] var3);

    public native String sm2EncryptFromHex(int var1, String var2, String var3);

    public native String sm2DecryptToHex(int var1, String var2, String var3);

    public native String sm2EncryptFromText(int var1, String var2, String var3);

    public native String sm2DecryptToText(int var1, String var2, String var3);

    public native byte[] sm2EncryptASN1FromData(byte[] var1, byte[] var2);

    public native byte[] sm2DecryptASN1ToData(byte[] var1, byte[] var2);

    public native String sm2EncryptASN1FromHex(String var1, String var2);

    public native String sm2DecryptASN1ToHex(String var1, String var2);

    public native String sm2EncryptASN1FromText(String var1, String var2);

    public native String sm2DecryptASN1ToText(String var1, String var2);

    public native byte[] sm2SignFromData(byte[] var1, byte[] var2);

    public native int sm2VerifySignFromData(byte[] var1, byte[] var2, byte[] var3);

    public native String sm2SignFromHex(String var1, String var2);

    public native int sm2VerifySignFromHex(String var1, String var2, String var3);

    public native String sm2SignFromText(String var1, String var2);

    public native int sm2VerifySignFromText(String var1, String var2, String var3);

    public native byte[] sm2SignASN1FromData(byte[] var1, byte[] var2);

    public native int sm2VerifySignASN1FromData(byte[] var1, byte[] var2, byte[] var3);

    public native String sm2SignASN1FromHex(String var1, String var2);

    public native int sm2VerifySignASN1FromHex(String var1, String var2, String var3);

    public native String sm2SignASN1FromText(String var1, String var2);

    public native int sm2VerifySignASN1FromText(String var1, String var2, String var3);

    private static String getOsName() {
        String osType = "win";
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        osType = osName.contains("win") ? "win" : (osName.contains("nix") || osName.contains("nux") || osName.contains("aix") ? "linux" : (osName.contains("mac") ? "mac" : "linux"));
        return osType;
    }

    private static String getExtension() {
        String extension = ".so";
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        extension = osName.contains("win") ? ".dll" : (osName.contains("nix") || osName.contains("nux") || osName.contains("aix") ? ".so" : (osName.contains("mac") ? ".dylib" : ".so"));
        return extension;
    }

    private static String getArchName() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        String sunArch = System.getProperty("sun.arch.data.model", "").toLowerCase(Locale.ROOT);
        String archType = "x64";
        archType = "64".equals(sunArch) ? (osArch.contains("arm64") || osArch.contains("aarch64") ? "arm64" : "x64") : ("32".equals(sunArch) ? "x86" : (osArch.contains("amd64") || osArch.contains("x86_64") ? "x64" : (osArch.contains("x86") || osArch.contains("i386") || osArch.contains("i486") || osArch.contains("i586") || osArch.contains("i686") ? "x86" : (osArch.contains("arm64") || osArch.contains("aarch64") ? "arm64" : "x64"))));
        return archType;
    }

    private static synchronized void loadLib(String libName) {
        File extractedLibFile;
        String osName = GmCryptoNativeUtil.getOsName();
        String dataModel = GmCryptoNativeUtil.getArchName();
        String libExtension = GmCryptoNativeUtil.getExtension();
        String libFullName = libName + "-" + osName + "-" + dataModel + libExtension;
        String libFileMd5 = GmCryptoNativeUtil.getFileMD5(libFullName);
        String libTimeName = libName + "-" + osName + "-" + dataModel + "-" + libFileMd5 + libExtension;
        String tempDir = System.getProperty("java.io.tmpdir");
        File smNativeFile = new File(tempDir, "GmNative");
        if (!smNativeFile.exists()) {
            smNativeFile.mkdir();
        }
        if (!(extractedLibFile = new File(smNativeFile + "/" + libTimeName)).exists()) {
            GmCryptoNativeUtil.copyFile(libFullName, extractedLibFile);
        }
        System.load(extractedLibFile.toString());
        GmCryptoNativeUtil.removeLib(smNativeFile, new String[]{libTimeName});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFileMD5(String libFullName) {
        try (InputStream in = GmCryptoNativeUtil.class.getResourceAsStream("/" + libFullName);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
            byte[] digest = md.digest();
            String string = ByteUtils.bytesToHex(digest);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("\u83b7\u53d6\u52a8\u6001\u5e93MD5\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
        catch (IOException e) {
            logger.warn("\u83b7\u53d6\u52a8\u6001\u5e93MD5\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String libFullName, File extractedLibFile) {
        BufferedInputStream reader = null;
        FileOutputStream writer = null;
        try (InputStream in = GmCryptoNativeUtil.class.getResourceAsStream("/" + libFullName);){
            reader = new BufferedInputStream(in);
            writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[1024];
            while (reader.read(buffer) > 0) {
                writer.write(buffer);
                buffer = new byte[1024];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("\u5173\u95ed\u52a8\u6001\u5e93\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.warn("\u5173\u95ed\u52a8\u6001\u5e93\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
    }

    private static void removeLib(File dir, String[] excludeLibName) {
        ArrayList<String> rmFiles = new ArrayList<String>();
        if (dir != null && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (GmCryptoNativeUtil.inExclude(file.getName(), excludeLibName)) continue;
                rmFiles.add(file.getName());
            }
        }
        for (String rmFile : rmFiles) {
            new File(dir, rmFile).delete();
        }
    }

    private static boolean inExclude(String fileName, String[] excludeLibName) {
        if (excludeLibName != null && excludeLibName.length > 0) {
            for (String libName : excludeLibName) {
                if (!libName.equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        GmCryptoNativeUtil.loadLib("libGmCryptoN");
    }
}

