/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.gmcrypto.util;

import java.io.UnsupportedEncodingException;

public class ByteUtils {
    private static final String HEX_STRING_MAPPING = "0123456789ABCDEF";
    public static final String CHARSET_NAME = "UTF-8";

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (byte unit : bytes) {
            int unitInt = unit & 0xFF;
            String unitHex = Integer.toHexString(unitInt);
            if (unitHex.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(unitHex);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexToBytes(String hexString) {
        if (hexString == null) {
            return null;
        }
        if (hexString.length() <= 0) {
            return new byte[0];
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            int step = i * 2;
            result[i] = (byte)(ByteUtils.charToByte(hexChars[step]) << 4 | ByteUtils.charToByte(hexChars[step + 1]));
        }
        return result;
    }

    public static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] stringToBytes(String str) {
        try {
            return str.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String hexToString(String hexString) {
        return ByteUtils.bytesToString(ByteUtils.hexToBytes(hexString));
    }

    public static String stringToHex(String str) {
        return ByteUtils.bytesToHex(ByteUtils.stringToBytes(str));
    }

    private static byte charToByte(char c) {
        return (byte)HEX_STRING_MAPPING.indexOf(c);
    }
}

