/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.gmcrypto.jni;

import cn.aotcloud.gmcrypto.GmCryptoNativeUtil;
import cn.aotcloud.gmcrypto.exception.GmCryptoException;
import cn.aotcloud.gmcrypto.util.StringUtils;

public class Sm4Utils {
    protected static final GmCryptoNativeUtil gmCryptoNativeUtil = new GmCryptoNativeUtil();

    protected static final byte[] removeDataZeroPadding(byte[] data) {
        int lastNonZeroIndex;
        if (data == null || data.length == 0) {
            return data;
        }
        for (lastNonZeroIndex = data.length - 1; lastNonZeroIndex >= 0 && data[lastNonZeroIndex] == 0; --lastNonZeroIndex) {
        }
        if (lastNonZeroIndex < 0) {
            return new byte[0];
        }
        byte[] originalData = new byte[lastNonZeroIndex + 1];
        System.arraycopy(data, 0, originalData, 0, originalData.length);
        return originalData;
    }

    public static String removeHexZeroPadding(String hex) {
        if (hex == null || hex.isEmpty()) {
            return hex;
        }
        while (hex.length() >= 2 && hex.endsWith("00")) {
            hex = hex.substring(0, hex.length() - 2);
        }
        return hex;
    }

    public static class CBC {
        public static String encryptFromText(String plainText, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainText)) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid plainText");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcEncryptFromText(plainText, keyHex, ivHex);
        }

        public static String encryptFromHex(String plainHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcEncryptFromHex(plainHex, keyHex, ivHex);
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes) throws GmCryptoException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid ivBytes");
            }
            return gmCryptoNativeUtil.sm4CbcEncryptFromData(plainBytes, keyBytes, ivBytes);
        }

        public static String noPaddingEncryptFromText(String plainText, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainText)) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid plainText");
            }
            if (StringUtils.endsWith(plainText, "\\s")) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromText]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcNoPaddingEncryptFromText(plainText, keyHex, ivHex);
        }

        public static String noPaddingEncryptFromHex(String plainHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.endsWith(plainHex, "20")) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromHex]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcNoPaddingEncryptFromHex(plainHex, keyHex, ivHex);
        }

        public static byte[] noPaddingEncryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes) throws GmCryptoException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid plainBytes");
            }
            if (plainBytes[plainBytes.length - 1] == 32) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:encryptFromData]invalid ivBytes");
            }
            return gmCryptoNativeUtil.sm4CbcNoPaddingEncryptFromData(plainBytes, keyBytes, ivBytes);
        }

        public static String decryptToText(String cipherHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcDecryptToText(cipherHex, keyHex, ivHex);
        }

        public static String decryptToHex(String cipherHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid ivHex");
            }
            String plantHex = gmCryptoNativeUtil.sm4CbcDecryptToHex(cipherHex, keyHex, ivHex);
            plantHex = Sm4Utils.removeHexZeroPadding(plantHex);
            return plantHex;
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes) throws GmCryptoException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid ivBytes");
            }
            byte[] plantData = gmCryptoNativeUtil.sm4CbcDecryptToData(cipherBytes, keyBytes, ivBytes);
            plantData = Sm4Utils.removeDataZeroPadding(plantData);
            return plantData;
        }

        public static String noPaddingDecryptToText(String cipherHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToText]invalid ivHex");
            }
            return gmCryptoNativeUtil.sm4CbcNoPaddingDecryptToText(cipherHex, keyHex, ivHex);
        }

        public static String noPaddingDecryptToHex(String cipherHex, String keyHex, String ivHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid keyHex");
            }
            if (StringUtils.length(ivHex) != 32) {
                throw new GmCryptoException("[SM4_CBC:decryptToHex]invalid ivHex");
            }
            String plantHex = gmCryptoNativeUtil.sm4CbcNoPaddingDecryptToHex(cipherHex, keyHex, ivHex);
            plantHex = Sm4Utils.removeHexZeroPadding(plantHex);
            return plantHex;
        }

        public static byte[] noPaddingDecryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes) throws GmCryptoException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid keyBytes");
            }
            if (ivBytes == null || ivBytes.length != 16) {
                throw new GmCryptoException("[SM4_CBC:decryptToData]invalid ivBytes");
            }
            byte[] plantData = gmCryptoNativeUtil.sm4CbcNoPaddingDecryptToData(cipherBytes, keyBytes, ivBytes);
            plantData = Sm4Utils.removeDataZeroPadding(plantData);
            return plantData;
        }
    }

    public static class ECB {
        public static String encryptFromText(String plainText, String keyHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainText)) {
                throw new GmCryptoException("[SM4_ECB:encryptFromText]invalid plainText");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:encryptFromText]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbEncryptFromText(plainText, keyHex);
        }

        public static String encryptFromHex(String plainHex, String keyHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new GmCryptoException("[SM4_ECB:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:encryptFromHex]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbEncryptFromHex(plainHex, keyHex);
        }

        public static byte[] encryptFromData(byte[] plainBytes, byte[] keyBytes) throws GmCryptoException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new GmCryptoException("[SM4_ECB:encryptFromData]invalid plainBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_ECB:encryptFromData]invalid keyBytes");
            }
            return gmCryptoNativeUtil.sm4EcbEncryptFromData(plainBytes, keyBytes);
        }

        public static String noPaddingEncryptFromText(String plainText, String keyHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainText)) {
                throw new GmCryptoException("[SM4_ECB:encryptFromText]invalid plainText");
            }
            if (StringUtils.endsWith(plainText, "\\s")) {
                throw new GmCryptoException("[SM4_ECB:encryptFromText]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:encryptFromText]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbNoPaddingEncryptFromText(plainText, keyHex);
        }

        public static String noPaddingEncryptFromHex(String plainHex, String keyHex) throws GmCryptoException {
            if (StringUtils.isEmpty(plainHex)) {
                throw new GmCryptoException("[SM4_ECB:encryptFromHex]invalid plainHex");
            }
            if (StringUtils.endsWith(plainHex, "20")) {
                throw new GmCryptoException("[SM4_ECB:encryptFromHex]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:encryptFromHex]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbNoPaddingEncryptFromHex(plainHex, keyHex);
        }

        public static byte[] noPaddingEncryptFromData(byte[] plainBytes, byte[] keyBytes) throws GmCryptoException {
            if (plainBytes == null || plainBytes.length == 0) {
                throw new GmCryptoException("[SM4_ECB:encryptFromData]invalid plainBytes");
            }
            if (plainBytes[plainBytes.length - 1] == 32) {
                throw new GmCryptoException("[SM4_ECB:encryptFromData]In NoPadding mode, the source Does not support ending with space or tab");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_ECB:encryptFromData]invalid keyBytes");
            }
            return gmCryptoNativeUtil.sm4EcbNoPaddingEncryptFromData(plainBytes, keyBytes);
        }

        public static String decryptToText(String cipherHex, String keyHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:decryptToText]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbDecryptToText(cipherHex, keyHex);
        }

        public static String decryptToHex(String cipherHex, String keyHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:decryptToHex]invalid keyHex");
            }
            String plantHex = gmCryptoNativeUtil.sm4EcbDecryptToHex(cipherHex, keyHex);
            plantHex = Sm4Utils.removeHexZeroPadding(plantHex);
            return plantHex;
        }

        public static byte[] decryptToData(byte[] cipherBytes, byte[] keyBytes) throws GmCryptoException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToData]invalid cipherBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_ECB:decryptToData]invalid keyBytes");
            }
            byte[] plantData = gmCryptoNativeUtil.sm4EcbDecryptToData(cipherBytes, keyBytes);
            plantData = Sm4Utils.removeDataZeroPadding(plantData);
            return plantData;
        }

        public static String noPaddingDecryptToText(String cipherHex, String keyHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToText]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:decryptToText]invalid keyHex");
            }
            return gmCryptoNativeUtil.sm4EcbNoPaddingDecryptToText(cipherHex, keyHex);
        }

        public static String noPaddingDecryptToHex(String cipherHex, String keyHex) throws GmCryptoException {
            if (StringUtils.length(keyHex) == 0 || cipherHex.length() % 32 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToHex]invalid cipherHex");
            }
            if (StringUtils.length(keyHex) != 32) {
                throw new GmCryptoException("[SM4_ECB:decryptToHex]invalid keyHex");
            }
            String plantHex = gmCryptoNativeUtil.sm4EcbNoPaddingDecryptToHex(cipherHex, keyHex);
            plantHex = Sm4Utils.removeHexZeroPadding(plantHex);
            return plantHex;
        }

        public static byte[] noPaddingDecryptToData(byte[] cipherBytes, byte[] keyBytes) throws GmCryptoException {
            if (cipherBytes == null || cipherBytes.length == 0 || cipherBytes.length % 16 != 0) {
                throw new GmCryptoException("[SM4_ECB:decryptToData]invalid cipherBytes");
            }
            if (keyBytes == null || keyBytes.length != 16) {
                throw new GmCryptoException("[SM4_ECB:decryptToData]invalid keyBytes");
            }
            byte[] plantData = gmCryptoNativeUtil.sm4EcbNoPaddingDecryptToData(cipherBytes, keyBytes);
            plantData = Sm4Utils.removeDataZeroPadding(plantData);
            return plantData;
        }
    }
}

