package cn.aotcloud.gmcrypto.jni;

import cn.aotcloud.gmcrypto.GmCryptoNativeUtil;
import cn.aotcloud.gmcrypto.exception.GmCryptoException;
import cn.aotcloud.gmcrypto.util.StringUtils;

public class Sm3Utils {

	protected static final GmCryptoNativeUtil gmCryptoNativeUtil = new GmCryptoNativeUtil();

	/**
	 * 字节码SM3加密
	 * 
	 * @param sourceBytes	明文字节码
	 * @return 加密字节码
	 * @throws GmCryptoException 
	 */
	public static byte[] encryptFromData(byte[] sourceData) throws GmCryptoException {
		if(sourceData==null || sourceData.length == 0) {
			throw new GmCryptoException("[SM3:encryptFromData]invalid sourceData");
		}
		return gmCryptoNativeUtil.sm3EncryptFromData(sourceData);
	}

	/**
	 * 字符串SM3加密
	 * 
	 * @param sourceHex		明文16进制串
	 * @return 16进制加密串
	 * @throws GmCryptoException 
	 */
	public static String encryptFromHex(String sourceHex) throws GmCryptoException {
		if(StringUtils.isEmpty(sourceHex)) {
			throw new GmCryptoException("[SM3:encryptFromHex]invalid sourceData");
		}
		return gmCryptoNativeUtil.sm3EncryptFromHex(sourceHex);
	}

	/**
	 * 字符串SM3加密
	 * 
	 * @param sourceText	明文字符串
	 * @return 16进制加密串
	 * @throws GmCryptoException 
	 */
	public static String encryptFromText(String sourceText) throws GmCryptoException {
		if(StringUtils.isEmpty(sourceText)) {
			throw new GmCryptoException("[SM3:encryptFromText]invalid sourceData");
		}
		return gmCryptoNativeUtil.sm3EncryptFromText(sourceText);
	}

}
