package cn.aotcloud.gmcrypto;

public class GmCryptoNativeUtil {

	public native String getVersion();

	public native String[] generateKeyPair();
	public native String getPublicKey(String prvHex);
	
	public native byte[] sm3EncryptFromData(byte[] sourceData);
	public native String sm3EncryptFromHex(String sourceHex);
	public native String sm3EncryptFromText(String sourceText);
	
	public native byte[] sm4EcbEncryptFromData(byte[] plainBytes, byte[] keyBytes);
	public native byte[] sm4EcbDecryptToData(byte[] cipherBytes, byte[] keyBytes);
	public native String sm4EcbEncryptFromHex(String plainHex, String keyHex);
	public native String sm4EcbDecryptToHex(String cipherHex, String keyHex);
	public native String sm4EcbEncryptFromText(String plainText, String keyHex);
	public native String sm4EcbDecryptToText(String cipherHex, String keyHex);
	
	public native byte[] sm4CbcEncryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes);
	public native byte[] sm4CbcDecryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes);
	public native String sm4CbcEncryptFromHex(String plainHex, String keyHex, String ivHex);
	public native String sm4CbcDecryptToHex(String cipherHex, String keyHex, String ivHex);
	public native String sm4CbcEncryptFromText(String plainText, String keyHex, String ivHex);
	public native String sm4CbcDecryptToText(String cipherHex, String keyHex, String ivHex);

	public native byte[] sm4EcbNoPaddingEncryptFromData(byte[] plainBytes, byte[] keyBytes);
	public native byte[] sm4EcbNoPaddingDecryptToData(byte[] cipherBytes, byte[] keyBytes);
	public native String sm4EcbNoPaddingEncryptFromHex(String plainHex, String keyHex);
	public native String sm4EcbNoPaddingDecryptToHex(String cipherHex, String keyHex);
	public native String sm4EcbNoPaddingEncryptFromText(String plainText, String keyHex);
	public native String sm4EcbNoPaddingDecryptToText(String cipherHex, String keyHex);
	
	public native byte[] sm4CbcNoPaddingEncryptFromData(byte[] plainBytes, byte[] keyBytes, byte[] ivBytes);
	public native byte[] sm4CbcNoPaddingDecryptToData(byte[] cipherBytes, byte[] keyBytes, byte[] ivBytes);
	public native String sm4CbcNoPaddingEncryptFromHex(String plainHex, String keyHex, String ivHex);
	public native String sm4CbcNoPaddingDecryptToHex(String cipherHex, String keyHex, String ivHex);
	public native String sm4CbcNoPaddingEncryptFromText(String plainText, String keyHex, String ivHex);
	public native String sm4CbcNoPaddingDecryptToText(String cipherHex, String keyHex, String ivHex);
	
	public native byte[] sm2EncryptFromData(int cipherMode, byte[] pubKeyBytes, byte[] sourceBytes);
	public native byte[] sm2DecryptToData(int cipherMode, byte[] prvKeyBytes, byte[] cipherBytes);
	public native String sm2EncryptFromHex(int cipherMode, String pubKeyHex, String sourceHex);
	public native String sm2DecryptToHex(int cipherMode, String prvKeyHex, String cipherHex);
	public native String sm2EncryptFromText(int cipherMode, String pubKeyHex, String sourceText);
	public native String sm2DecryptToText(int cipherMode, String prvKeyHex, String cipherHex);
	
	public native byte[] sm2EncryptASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes);
	public native byte[] sm2DecryptASN1ToData(byte[] prvKeyBytes, byte[] cipherBytes);
	public native String sm2EncryptASN1FromHex(String pubKeyHex, String sourceHex);
	public native String sm2DecryptASN1ToHex(String prvKeyHex, String cipherHex);
	public native String sm2EncryptASN1FromText(String pubKeyHex, String sourceText);
	public native String sm2DecryptASN1ToText(String prvKeyHex, String cipherHex);
	
	public native byte[] sm2SignFromData(byte[] prvKeyBytes, byte[] sourceBytes);
	public native int sm2VerifySignFromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes);
	public native String sm2SignFromHex(String prvKeyHex, String sourceHex);
	public native int sm2VerifySignFromHex(String pubKeyHex, String sourceHex, String signHex);
	public native String sm2SignFromText(String prvKeyHex, String sourceText);
	public native int sm2VerifySignFromText(String pubKeyHex, String sourceText, String signHex);
	
	public native byte[] sm2SignASN1FromData(byte[] prvKeyBytes, byte[] sourceBytes);
	public native int sm2VerifySignASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes);
	public native String sm2SignASN1FromHex(String prvKeyHex, String sourceHex);
	public native int sm2VerifySignASN1FromHex(String pubKeyHex, String sourceHex, String signHex);
	public native String sm2SignASN1FromText(String prvKeyHex, String sourceText);
	public native int sm2VerifySignASN1FromText(String pubKeyHex, String sourceText, String signHex);

	static {
		System.loadLibrary("GmCryptoN");
	}

}
