/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.gmcrypto.jni;

import cn.aotcloud.gmcrypto.CipherMode;
import cn.aotcloud.gmcrypto.GmCryptoNativeUtil;
import cn.aotcloud.gmcrypto.exception.GmCryptoException;
import cn.aotcloud.gmcrypto.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Sm2Utils {
    protected final GmCryptoNativeUtil gmCryptoNativeUtil = new GmCryptoNativeUtil();
    private CipherMode cipherMode = CipherMode.C1C2C3;
    private static final List<Integer> keyHexLenList = Arrays.asList(60, 62, 64, 66, 68, 128);
    private static final List<Integer> keyByteLenList = Arrays.asList(30, 31, 32, 33, 34, 64);

    public Sm2Utils() {
    }

    public Sm2Utils(CipherMode cipherMode) {
        this.cipherMode = cipherMode;
    }

    public String[] generateKeyPair() {
        return this.gmCryptoNativeUtil.generateKeyPair();
    }

    public String getPublicKey(String prvKeyHex) {
        return this.gmCryptoNativeUtil.getPublicKey(prvKeyHex);
    }

    public String encryptFromText(String pubKeyHex, String sourceText) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:encryptFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:encryptFromText]invalid sourceText");
        }
        if (StringUtils.length(pubKeyHex) < 130 && !pubKeyHex.startsWith("04")) {
            pubKeyHex = "04" + pubKeyHex;
        }
        return this.gmCryptoNativeUtil.sm2EncryptFromText(this.cipherMode.getValue(), pubKeyHex, sourceText);
    }

    public String encryptFromHex(String pubKeyHex, String sourceHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:encryptFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:encryptFromHex]invalid sourceHex");
        }
        if (pubKeyHex.length() < 130 && !pubKeyHex.startsWith("04")) {
            pubKeyHex = "04" + pubKeyHex;
        }
        return this.gmCryptoNativeUtil.sm2EncryptFromHex(this.cipherMode.getValue(), pubKeyHex, sourceHex);
    }

    public byte[] encryptFromData(byte[] pubKeyBytes, byte[] sourceBytes) throws GmCryptoException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new GmCryptoException("[SM2:encryptFromBytes]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:encryptFromBytes]invalid sourceBytes");
        }
        return this.gmCryptoNativeUtil.sm2EncryptFromData(this.cipherMode.getValue(), pubKeyBytes, sourceBytes);
    }

    public String decryptToText(String prvKeyHex, String cipherHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:decryptToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new GmCryptoException("[SM2:decryptToText]invalid cipherHex");
        }
        return this.gmCryptoNativeUtil.sm2DecryptToText(this.cipherMode.getValue(), prvKeyHex, cipherHex);
    }

    public String decryptToHex(String prvKeyHex, String cipherHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:decryptToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new GmCryptoException("[SM2:decryptToHex]invalid cipherHex");
        }
        return this.gmCryptoNativeUtil.sm2DecryptToHex(this.cipherMode.getValue(), prvKeyHex, cipherHex);
    }

    public byte[] decryptToData(byte[] prvKeyBytes, byte[] cipherBytes) throws GmCryptoException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new GmCryptoException("[SM2:decryptToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(cipherBytes)) {
            throw new GmCryptoException("[SM2:decryptToData]invalid cipherBytes");
        }
        return this.gmCryptoNativeUtil.sm2DecryptToData(this.cipherMode.getValue(), prvKeyBytes, cipherBytes);
    }

    public String encryptASN1FromText(String pubKeyHex, String sourceText) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:encryptASN1FromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:encryptASN1FromText]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2EncryptASN1FromText(pubKeyHex, sourceText);
    }

    public String encryptASN1FromHex(String pubKeyHex, String sourceHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:encryptASN1FromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:encryptASN1FromHex]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2EncryptASN1FromHex(pubKeyHex, sourceHex);
    }

    public byte[] encryptASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes) throws GmCryptoException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new GmCryptoException("[SM2:encryptASN1FromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:encryptASN1FromData]invalid sourceBytes");
        }
        return this.gmCryptoNativeUtil.sm2EncryptASN1FromData(pubKeyBytes, sourceBytes);
    }

    public String decryptASN1ToText(String prvKeyHex, String cipherHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:decryptASN1ToText]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new GmCryptoException("[SM2:decryptASN1ToText]invalid cipherHex");
        }
        return this.gmCryptoNativeUtil.sm2DecryptASN1ToText(prvKeyHex, cipherHex);
    }

    public String decryptASN1ToHex(String prvKeyHex, String cipherHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:decryptASN1ToHex]invalid prvKeyHex");
        }
        if (this.invalidCipherObj(cipherHex)) {
            throw new GmCryptoException("[SM2:decryptASN1ToHex]invalid cipherHex");
        }
        return this.gmCryptoNativeUtil.sm2DecryptASN1ToHex(prvKeyHex, cipherHex);
    }

    public byte[] decryptASN1ToData(byte[] prvKeyBytes, byte[] cipherBytes) throws GmCryptoException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new GmCryptoException("[SM2:decryptASN1ToData]invalid prvKeyBytes");
        }
        if (this.invalidCipherObj(cipherBytes)) {
            throw new GmCryptoException("[SM2:decryptASN1ToData]invalid cipherBytes");
        }
        return this.gmCryptoNativeUtil.sm2DecryptASN1ToData(prvKeyBytes, cipherBytes);
    }

    public String signFromText(String prvKeyHex, String sourceText) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:signFromText]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2SignFromText(prvKeyHex, sourceText);
    }

    public String signFromHex(String prvKeyHex, String sourceHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:signFromHex]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2SignFromHex(prvKeyHex, sourceHex);
    }

    public byte[] signFromData(byte[] prvKeyBytes, byte[] sourceBytes) throws GmCryptoException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new GmCryptoException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:signFromData]invalid sourceBytes");
        }
        return this.gmCryptoNativeUtil.sm2SignFromData(prvKeyBytes, sourceBytes);
    }

    public boolean verifySignFromText(String pubKeyHex, String sourceText, String signHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid signHex");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignFromText(pubKeyHex, sourceText, signHex) == 1;
    }

    public boolean verifySignFromHex(String pubKeyHex, String sourceHex, String signHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid signHex");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignFromHex(pubKeyHex, sourceHex, signHex) == 1;
    }

    public boolean verifySignFromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes) throws GmCryptoException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (signBytes == null || signBytes.length == 0) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid signBytes");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignFromData(pubKeyBytes, sourceBytes, signBytes) == 1;
    }

    public String signASN1FromText(String prvKeyHex, String sourceText) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:signFromText]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:signFromText]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2SignASN1FromText(prvKeyHex, sourceText);
    }

    public String signASN1FromHex(String prvKeyHex, String sourceHex) throws GmCryptoException {
        if (this.invalidKey(prvKeyHex)) {
            throw new GmCryptoException("[SM2:signFromHex]invalid prvKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:signFromHex]invalid sourceText");
        }
        return this.gmCryptoNativeUtil.sm2SignASN1FromHex(prvKeyHex, sourceHex);
    }

    public byte[] signASN1FromData(byte[] prvKeyBytes, byte[] sourceBytes) throws GmCryptoException {
        if (this.invalidKey(prvKeyBytes)) {
            throw new GmCryptoException("[SM2:signFromData]invalid prvKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:signFromData]invalid sourceBytes");
        }
        return this.gmCryptoNativeUtil.sm2SignASN1FromData(prvKeyBytes, sourceBytes);
    }

    public boolean verifySignASN1FromText(String pubKeyHex, String sourceText, String signHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:verifySignFromText]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceText) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromText]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid signHex");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignASN1FromText(pubKeyHex, sourceText, signHex) == 1;
    }

    public boolean verifySignASN1FromHex(String pubKeyHex, String sourceHex, String signHex) throws GmCryptoException {
        if (this.invalidKey(pubKeyHex)) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid pubKeyHex");
        }
        if (StringUtils.length(sourceHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid sourceText");
        }
        if (StringUtils.length(signHex) == 0) {
            throw new GmCryptoException("[SM2:verifySignFromHex]invalid signHex");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignASN1FromHex(pubKeyHex, sourceHex, signHex) == 1;
    }

    public boolean verifySignASN1FromData(byte[] pubKeyBytes, byte[] sourceBytes, byte[] signBytes) throws GmCryptoException {
        if (this.invalidKey(pubKeyBytes)) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid pubKeyBytes");
        }
        if (sourceBytes == null || sourceBytes.length == 0) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid sourceBytes");
        }
        if (signBytes == null || signBytes.length == 0) {
            throw new GmCryptoException("[SM2:verifySignFromData]invalid signBytes");
        }
        return this.gmCryptoNativeUtil.sm2VerifySignASN1FromData(pubKeyBytes, sourceBytes, signBytes) == 1;
    }

    private final boolean invalidKey(Object keyObj) {
        if (keyObj == null) {
            return true;
        }
        if (keyObj instanceof String) {
            String keyString = (String)keyObj;
            int keyLength = keyString.length();
            if (keyLength == 130 && keyString.startsWith("04")) {
                return false;
            }
            return !keyHexLenList.contains(keyLength);
        }
        if (keyObj instanceof byte[]) {
            byte[] keyBytes = (byte[])keyObj;
            if (keyBytes.length == 65 && keyBytes[0] == 4) {
                return false;
            }
            return !keyByteLenList.contains(keyBytes.length);
        }
        return true;
    }

    private final boolean invalidCipherObj(Object cipherObj) {
        if (cipherObj == null) {
            return true;
        }
        if (cipherObj instanceof String) {
            String cipherHex = (String)cipherObj;
            int cipherLength = cipherHex.length();
            return cipherLength < 196 || cipherLength % 2 == 1;
        }
        if (cipherObj instanceof byte[]) {
            byte[] cipherBytes = (byte[])cipherObj;
            return cipherBytes.length < 98;
        }
        return true;
    }
}

