/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.common.validators;

import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.utils.OAuthUtils;
import cn.aotcloud.oauth2.altu.oauth2.common.validators.OAuthValidator;
import cn.aotcloud.utils.HttpServletUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class II11iIiI<T extends HttpServletRequest>
implements OAuthValidator<T> {
    protected List<String> II11iIiI = new ArrayList<String>();
    protected Map<String, String[]> I111ii1I = new HashMap<String, String[]>();
    protected List<String> i111IiI1 = new ArrayList<String>();
    protected boolean i1iI111I;

    @Override
    public void validateMethod(T request) throws OAuthProblemException {
        if (!request.getMethod().equals("POST")) {
            throw OAuthUtils.handleOAuthProblemException("Method not set to POST.");
        }
    }

    @Override
    public void validateContentType(T request) throws OAuthProblemException {
        String string = HttpServletUtil.getContentType(request);
        String string2 = "application/x-www-form-urlencoded";
        if (!OAuthUtils.hasContentType(string, "application/x-www-form-urlencoded")) {
            throw OAuthUtils.handleBadContentTypeException("application/x-www-form-urlencoded");
        }
    }

    @Override
    public void validateRequiredParameters(T request) throws OAuthProblemException {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.II11iIiI) {
            String string2 = HttpServletUtil.getParameter(request, string);
            if (!OAuthUtils.isEmpty(string2)) continue;
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(hashSet);
        }
    }

    @Override
    public void validateOptionalParameters(T request) throws OAuthProblemException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, String[]> entry : this.I111ii1I.entrySet()) {
            String[] stringArray;
            String string = entry.getKey();
            String string2 = HttpServletUtil.getParameter(request, string);
            if (OAuthUtils.isEmpty(string2) || OAuthUtils.hasEmptyValues(stringArray = entry.getValue())) continue;
            for (String string3 : stringArray) {
                string2 = HttpServletUtil.getParameter(request, string3);
                if (!OAuthUtils.isEmpty(string2)) continue;
                hashSet.add(string3);
            }
        }
        if (!hashSet.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(hashSet);
        }
    }

    @Override
    public void validateNotAllowedParameters(T request) throws OAuthProblemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.i111IiI1) {
            String string2 = HttpServletUtil.getParameter(request, string);
            if (OAuthUtils.isEmpty(string2)) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw OAuthUtils.handleNotAllowedParametersOAuthException(arrayList);
        }
    }

    @Override
    public void validateClientAuthenticationCredentials(T request) throws OAuthProblemException {
        if (this.i1iI111I) {
            HashSet<String> hashSet = new HashSet<String>();
            String string = HttpServletUtil.getHeader(request, "Authorization");
            String[] stringArray = OAuthUtils.decodeClientAuthenticationHeader(string);
            if (stringArray == null || OAuthUtils.isEmpty(stringArray[0]) || OAuthUtils.isEmpty(stringArray[1])) {
                if (OAuthUtils.isEmpty(HttpServletUtil.getParameter(request, "client_id"))) {
                    hashSet.add("client_id");
                }
                if (OAuthUtils.isEmpty(HttpServletUtil.getParameter(request, "client_secret"))) {
                    hashSet.add("client_secret");
                }
            }
            if (!hashSet.isEmpty()) {
                throw OAuthUtils.handleMissingParameters(hashSet);
            }
        }
    }

    @Override
    public void performAllValidations(T request) throws OAuthProblemException {
        this.validateContentType(request);
        this.validateMethod(request);
        this.validateRequiredParameters(request);
        this.validateOptionalParameters(request);
        this.validateNotAllowedParameters(request);
        this.validateClientAuthenticationCredentials(request);
    }
}

