/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.filter;

import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.filter.I111ii1I;
import cn.aotcloud.utils.IOUtils;
import cn.aotcloud.utils.ServletUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHttpRequestWrapper
extends HttpServletRequestWrapper {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, String[]> paramValuesMap = new HashMap<String, String[]>();
    private byte[] buffer = null;

    public BodyHttpRequestWrapper(HttpServletRequest request) {
        super(request);
        this.paramValuesMap.putAll(request.getParameterMap());
        this.copyInputStream();
    }

    public BodyHttpRequestWrapper(HttpServletRequest request, boolean copy) {
        super(request);
        if (copy) {
            this.paramValuesMap.putAll(request.getParameterMap());
            this.copyInputStream();
        }
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public Enumeration<String> getParameterNames() {
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.paramValuesMap.get(name);
    }

    public void setParameterValues(String name, String[] values) {
        this.paramValuesMap.put(name, values);
    }

    public void removeParameter(String name) {
        this.paramValuesMap.remove(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramValuesMap;
    }

    public void setParameterMap(Map<String, String[]> paramValuesMap) {
        this.paramValuesMap = paramValuesMap;
    }

    public String getParameter(String name) {
        if (this.paramValuesMap.get(name) == null) {
            return null;
        }
        return this.paramValuesMap.get(name)[0];
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.buffer != null) {
            return new I111ii1I(this.buffer);
        }
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), ServletUtils.readCharacterEncoding((HttpServletRequest)this)));
    }

    public String getBodyString() {
        String string = null;
        try {
            string = new String(this.buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error("\u8bf7\u6c42\u8f7d\u8377\u8f6c\u6362\u672a\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38\uff1a{}", (Object)ExceptionUtil.getMessage(unsupportedEncodingException));
        }
        return string;
    }

    public void copyInputStream() {
        ServletInputStream servletInputStream = null;
        try {
            servletInputStream = super.getInputStream();
            if (servletInputStream != null) {
                this.buffer = IOUtils.toByteArray((InputStream)servletInputStream);
            }
        }
        catch (IOException iOException) {
            this.logger.error("\u590d\u5236\u8bf7\u6c42\u6d41\u65f6\u5f02\u5e38\uff1a{}", (Object)ExceptionUtil.getMessage(iOException));
        }
        finally {
            IOUtils.closeQuietly((InputStream)servletInputStream);
        }
    }
}

