/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.entity;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class WeiXinResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer errcode;
    private String errmsg;

    public Integer getErrcode() {
        return this.errcode;
    }

    public void setErrcode(Integer errcode) {
        this.errcode = errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public String localErrMsg() {
        return this.localErrMsg(this.errmsg);
    }

    public String localErrMsg(String errMsg) {
        WexinErrorCode wexinErrorCode = WexinErrorCode.valueOfCode(this.errcode);
        return wexinErrorCode == null ? errMsg : wexinErrorCode.errMsg();
    }

    public static WeiXinResult successResult() {
        WeiXinResult weiXinResult = new WeiXinResult();
        weiXinResult.setErrcode(0);
        weiXinResult.setErrmsg("ok");
        return weiXinResult;
    }

    public boolean isSuccess() {
        if (this.errcode != null) {
            return this.errcode == 0;
        }
        return StringUtils.equalsAnyIgnoreCase((CharSequence)this.errmsg, (CharSequence[])new CharSequence[]{"ok"});
    }

    public static enum WexinErrorCode {
        E_1(-1, "\u7cfb\u7edf\u7e41\u5fd9"),
        E0(0, "\u8bf7\u6c42\u6210\u529f"),
        E40001(40001, "\u4e0d\u5408\u6cd5\u7684secret\u53c2\u6570"),
        E40056(40056, "\u4e0d\u5408\u6cd5\u7684agentid"),
        E40057(40057, "\u4e0d\u5408\u6cd5\u7684callbackurl\u6216\u8005callbackurl\u9a8c\u8bc1\u5931\u8d25"),
        E46003(46003, "\u83dc\u5355\u672a\u8bbe\u7f6e"),
        E94000(94000, "\u5e94\u7528\u672a\u5f00\u542f\u5de5\u4f5c\u53f0\u81ea\u5b9a\u4e49\u6a21\u5f0f");

        private final String errMsg;
        private final Integer code;

        private WexinErrorCode(Integer code, String message) {
            this.code = code;
            this.errMsg = message;
        }

        public String errMsg() {
            return this.errMsg;
        }

        public int errCode() {
            return this.code;
        }

        public static WexinErrorCode valueOfCode(Integer code) {
            String string = "E" + String.valueOf(code).replace("-", "_");
            return WexinErrorCode.valueOf(string);
        }
    }
}

