/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.cache;

import cn.aotcloud.cache.CacheStorage;
import cn.aotcloud.cache.MemoryCacheStorage;
import cn.aotcloud.cache.NoneCacheStorage;
import cn.aotcloud.cache.RedisCacheStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class CacheStorageManager {
    private StoreType storeType;
    private RedisConnectionFactory connectionFactory;

    public CacheStorageManager(StoreType storeType, @Autowired(required=false) RedisConnectionFactory connectionFactory) {
        this.storeType = storeType;
        this.connectionFactory = connectionFactory;
    }

    public <T> CacheStorage<T> createCacheStorage(String prefix, long expiryTime) {
        CacheStorage cacheStorage = null;
        cacheStorage = this.storeType != null && this.storeType == StoreType.REDIS ? new RedisCacheStorage(this.connectionFactory, prefix, expiryTime) : (this.storeType != null && this.storeType == StoreType.NONE ? new MemoryCacheStorage(prefix, expiryTime) : new NoneCacheStorage());
        return cacheStorage;
    }
}

