/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.retry;

import cn.aotcloud.retry.Attempt;
import cn.aotcloud.retry.WaitStrategy;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

public final class i11I1I1i {
    private static final WaitStrategy II11iIiI = new iI1II1Ii(0L);

    private i11I1I1i() {
    }

    public static WaitStrategy II11iIiI() {
        return II11iIiI;
    }

    public static WaitStrategy II11iIiI(long l, @Nonnull TimeUnit timeUnit) throws IllegalStateException {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The time unit may not be null");
        return new iI1II1Ii(timeUnit.toMillis(l));
    }

    public static WaitStrategy I111ii1I(long l, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The time unit may not be null");
        return new Iii11I11(0L, timeUnit.toMillis(l));
    }

    public static WaitStrategy II11iIiI(long l, @Nonnull TimeUnit timeUnit, long l2, @Nonnull TimeUnit timeUnit2) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The minimum time unit may not be null");
        Preconditions.checkNotNull((Object)((Object)timeUnit2), (Object)"The maximum time unit may not be null");
        return new Iii11I11(timeUnit.toMillis(l), timeUnit2.toMillis(l2));
    }

    public static WaitStrategy I111ii1I(long l, @Nonnull TimeUnit timeUnit, long l2, @Nonnull TimeUnit timeUnit2) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The initial sleep time unit may not be null");
        Preconditions.checkNotNull((Object)((Object)timeUnit2), (Object)"The increment time unit may not be null");
        return new I1iIiI1I(timeUnit.toMillis(l), timeUnit2.toMillis(l2));
    }

    public static WaitStrategy I111ii1I() {
        return new i111IiI1(1L, Long.MAX_VALUE);
    }

    public static WaitStrategy i111IiI1(long l, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The maximum time unit may not be null");
        return new i111IiI1(1L, timeUnit.toMillis(l));
    }

    public static WaitStrategy II11iIiI(long l, long l2, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The maximum time unit may not be null");
        return new i111IiI1(l, timeUnit.toMillis(l2));
    }

    public static WaitStrategy i111IiI1() {
        return new i1iI111I(1L, Long.MAX_VALUE);
    }

    public static WaitStrategy i1iI111I(long l, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The maximum time unit may not be null");
        return new i1iI111I(1L, timeUnit.toMillis(l));
    }

    public static WaitStrategy I111ii1I(long l, long l2, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The maximum time unit may not be null");
        return new i1iI111I(l, timeUnit.toMillis(l2));
    }

    public static <T extends Throwable> WaitStrategy II11iIiI(@Nonnull Class<T> clazz, @Nonnull Function<T, Long> function) {
        Preconditions.checkNotNull(clazz, (Object)"exceptionClass may not be null");
        Preconditions.checkNotNull(function, (Object)"function may not be null");
        return new I111ii1I<T>(clazz, function);
    }

    public static WaitStrategy II11iIiI(WaitStrategy ... waitStrategyArray) {
        Preconditions.checkState((waitStrategyArray.length > 0 ? 1 : 0) != 0, (Object)"Must have at least one wait strategy");
        ArrayList arrayList = Lists.newArrayList((Object[])waitStrategyArray);
        Preconditions.checkState((!arrayList.contains(null) ? 1 : 0) != 0, (Object)"Cannot have a null wait strategy");
        return new II11iIiI(arrayList);
    }

    @Immutable
    private static final class I111ii1I<T extends Throwable>
    implements WaitStrategy {
        private final Class<T> II11iIiI;
        private final Function<T, Long> I111ii1I;

        public I111ii1I(@Nonnull Class<T> clazz, @Nonnull Function<T, Long> function) {
            this.II11iIiI = clazz;
            this.I111ii1I = function;
        }

        @Override
        public long computeSleepTime(Attempt lastAttempt) {
            Throwable throwable;
            if (lastAttempt.hasException() && this.II11iIiI.isAssignableFrom((throwable = lastAttempt.getExceptionCause()).getClass())) {
                return (Long)this.I111ii1I.apply((Object)throwable);
            }
            return 0L;
        }
    }

    @Immutable
    private static final class II11iIiI
    implements WaitStrategy {
        private final List<WaitStrategy> II11iIiI;

        public II11iIiI(List<WaitStrategy> list) {
            Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0, (Object)"Need at least one wait strategy");
            this.II11iIiI = list;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            long l = 0L;
            for (WaitStrategy waitStrategy : this.II11iIiI) {
                l += waitStrategy.computeSleepTime(failedAttempt);
            }
            return l;
        }
    }

    @Immutable
    private static final class i1iI111I
    implements WaitStrategy {
        private final long II11iIiI;
        private final long I111ii1I;

        public i1iI111I(long l, long l2) {
            Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (String)"multiplier must be > 0 but is %d", (long)l);
            Preconditions.checkArgument((l2 >= 0L ? 1 : 0) != 0, (String)"maximumWait must be >= 0 but is %d", (long)l2);
            Preconditions.checkArgument((l < l2 ? 1 : 0) != 0, (String)"multiplier must be < maximumWait but is %d", (long)l);
            this.II11iIiI = l;
            this.I111ii1I = l2;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            long l = this.II11iIiI(failedAttempt.getAttemptNumber());
            long l2 = this.II11iIiI * l;
            if (l2 > this.I111ii1I || l2 < 0L) {
                l2 = this.I111ii1I;
            }
            return l2 >= 0L ? l2 : 0L;
        }

        private long II11iIiI(long l) {
            if (l == 0L) {
                return 0L;
            }
            if (l == 1L) {
                return 1L;
            }
            long l2 = 0L;
            long l3 = 1L;
            long l4 = 0L;
            for (long i = 2L; i <= l; ++i) {
                l4 = l3 + l2;
                l2 = l3;
                l3 = l4;
            }
            return l4;
        }
    }

    @Immutable
    private static final class i111IiI1
    implements WaitStrategy {
        private final long II11iIiI;
        private final long I111ii1I;

        public i111IiI1(long l, long l2) {
            Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (String)"multiplier must be > 0 but is %d", (long)l);
            Preconditions.checkArgument((l2 >= 0L ? 1 : 0) != 0, (String)"maximumWait must be >= 0 but is %d", (long)l2);
            Preconditions.checkArgument((l < l2 ? 1 : 0) != 0, (String)"multiplier must be < maximumWait but is %d", (long)l);
            this.II11iIiI = l;
            this.I111ii1I = l2;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            double d = Math.pow(2.0, failedAttempt.getAttemptNumber());
            long l = Math.round((double)this.II11iIiI * d);
            if (l > this.I111ii1I) {
                l = this.I111ii1I;
            }
            return l >= 0L ? l : 0L;
        }
    }

    @Immutable
    private static final class I1iIiI1I
    implements WaitStrategy {
        private final long II11iIiI;
        private final long I111ii1I;

        public I1iIiI1I(long l, long l2) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"initialSleepTime must be >= 0 but is %d", (long)l);
            this.II11iIiI = l;
            this.I111ii1I = l2;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            long l = this.II11iIiI + this.I111ii1I * (failedAttempt.getAttemptNumber() - 1L);
            return l >= 0L ? l : 0L;
        }
    }

    @Immutable
    private static final class Iii11I11
    implements WaitStrategy {
        private static final Random II11iIiI = new Random();
        private final long I111ii1I;
        private final long i111IiI1;

        public Iii11I11(long l, long l2) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"minimum must be >= 0 but is %d", (long)l);
            Preconditions.checkArgument((l2 > l ? 1 : 0) != 0, (String)"maximum must be > minimum but maximum is %d and minimum is", (long)l2, (long)l);
            this.I111ii1I = l;
            this.i111IiI1 = l2;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            long l = Math.abs(II11iIiI.nextLong()) % (this.i111IiI1 - this.I111ii1I);
            return l + this.I111ii1I;
        }
    }

    @Immutable
    private static final class iI1II1Ii
    implements WaitStrategy {
        private final long II11iIiI;

        public iI1II1Ii(long l) {
            Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"sleepTime must be >= 0 but is %d", (long)l);
            this.II11iIiI = l;
        }

        @Override
        public long computeSleepTime(Attempt failedAttempt) {
            return this.II11iIiI;
        }
    }
}

