/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.support;

import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.oauth2.LoginFailStrategy;
import cn.aotcloud.utils.HttpRequestUtil;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.FileCopyUtils;

public class DefaultLoginFailStrategy
implements LoginFailStrategy {
    private String onLoginFailUri;

    public DefaultLoginFailStrategy(String onLoginFailUri) {
        this.onLoginFailUri = onLoginFailUri;
    }

    @Override
    public void onFail(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Exception e) throws IOException {
        if (this.onLoginFailUri != null) {
            HttpRequestUtil.sendRedirect(servletResponse, this.onLoginFailUri);
        } else {
            HttpServletUtil.setStatus(servletResponse, HttpStatus.FORBIDDEN.value());
            HttpServletUtil.setCharacterEncoding(servletResponse, "UTF-8");
            HttpServletUtil.setHeader(servletResponse, "Strict-Transport-Security", "max-age=31536000; includeSubDomains;preload");
            FileCopyUtils.copy((String)ExceptionUtil.getMessage(e), (Writer)HttpServletUtil.getPrintWriter(servletResponse));
        }
    }
}

