/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.client.response;

import cn.aotcloud.oauth2.altu.oauth2.client.II11iIiI.i1iI111I;
import cn.aotcloud.oauth2.altu.oauth2.client.response.i111IiI1;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.utils.OAuthUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthResourceResponse
extends i111IiI1 {
    private static final Logger logger = LoggerFactory.getLogger(OAuthResourceResponse.class);
    private InputStream inputStream;
    private boolean bodyRetrieved = false;

    public OAuthResourceResponse() {
        this.validator = new i1iI111I();
    }

    public String getBody() {
        if (this.bodyRetrieved && this.body == null) {
            throw new IllegalStateException("Cannot call getBody() after getBodyAsInputStream()");
        }
        if (this.body == null) {
            try {
                if (this.bodyRetrieved && this.inputStream == null) {
                    throw new IllegalStateException("Cannot call getBodyAsInputStream() after getBody()");
                }
                this.bodyRetrieved = true;
                this.body = OAuthUtils.saveStreamAsString(this.inputStream);
            }
            catch (IOException iOException) {
                logger.error("Failed to convert InputStream to String", (Throwable)iOException);
            }
            finally {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.body;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected void setBody(InputStream body) throws OAuthProblemException {
        this.inputStream = body;
    }

    @Override
    protected void setBody(String body) throws OAuthProblemException {
        this.body = body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getBodyAsInputStream() {
        if (this.bodyRetrieved && this.inputStream == null) {
            throw new IllegalStateException("Cannot call getBodyAsInputStream() after getBody()");
        }
        this.bodyRetrieved = true;
        return this.inputStream;
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Override
    protected void init(InputStream body, String contentType, int responseCode, Map<String, List<String>> headers) throws OAuthProblemException {
        this.setBody(body);
        this.setContentType(contentType);
        this.setResponseCode(responseCode);
        this.setHeaders(headers);
    }
}

