/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;

public class LoggerHandle {
    protected static final NamedThreadLocal<String> USERINFO_THREAD_LOCAL = new NamedThreadLocal("LoggerHandle UserInfo Thread Local");
    protected Logger logger = null;

    public LoggerHandle(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public LoggerHandle(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void setUserInfo(String userInfo) {
        USERINFO_THREAD_LOCAL.set((Object)userInfo);
    }

    public String getUserInfo(boolean tab, boolean conf) {
        return "";
    }

    public String getUserInfo(boolean tab) {
        return this.getUserInfo(tab, true);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.debug(this.getUserInfo(true) + msg);
    }

    public void debug(String format, Object ... arguments) {
        this.logger.debug(this.getUserInfo(true) + format, arguments);
    }

    public void info(String msg) {
        this.logger.info(this.getUserInfo(true) + msg);
    }

    public void info(boolean userinfo, String msg) {
        this.logger.info(userinfo ? this.getUserInfo(true) : "" + msg);
    }

    public void info(String format, Object ... arguments) {
        this.logger.info(this.getUserInfo(true) + format, arguments);
    }

    public void info(boolean conf, String format, Object ... arguments) {
        this.logger.info(this.getUserInfo(true, conf) + format, arguments);
    }

    public void warn(String msg) {
        this.logger.warn(this.getUserInfo(true) + msg);
    }

    public void warn(Throwable t) {
        this.logger.warn(this.getUserInfo(true) + t.getMessage());
    }

    public void warn(String format, Object ... arguments) {
        this.logger.warn(this.getUserInfo(true) + format, arguments);
    }

    public void error(String msg) {
        this.logger.error(this.getUserInfo(true) + msg);
    }

    public void error(boolean userinfo, String msg) {
        this.logger.error(userinfo ? this.getUserInfo(true) : "" + msg);
    }

    public void error(String format, Object ... arguments) {
        this.logger.error(this.getUserInfo(true) + format, arguments);
    }

    public void error(Throwable t) {
        this.logger.error(this.getUserInfo(true) + t.getMessage());
    }

    public void error(String msg, Throwable t) {
        this.logger.error(this.getUserInfo(true) + msg, t);
    }

    public void jobInfo(String format, Object ... arguments) {
        this.logger.info(format, arguments);
    }

    public void jobError(String format, Object ... arguments) {
        this.logger.error(format, arguments);
    }

    public void taskInfo(String userInfo, String msg) {
        this.logger.info(userInfo + msg);
    }

    public void taskInfo(String userInfo, String format, Object ... arguments) {
        this.logger.info(userInfo + format, arguments);
    }

    public void taskError(String userInfo, String msg) {
        this.logger.error(userInfo + msg);
    }

    public void taskError(String userInfo, String format, Object ... arguments) {
        this.logger.error(userInfo + format, arguments);
    }

    public void taskdebug(String userInfo, String msg) {
        this.logger.debug(userInfo + msg);
    }

    public void taskdebug(String userInfo, String format, Object ... arguments) {
        this.logger.debug(userInfo + format, arguments);
    }
}

