/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support.simple;

import cn.aotcloud.crypto.pcode.PcodeEncoder;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.security.oncetoken.II11iIiI;
import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import org.apache.commons.lang3.StringUtils;

public class SimpleRequestTokenValidator
implements RequestTokenValidator {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());
    protected final RequestTokenStore requestTokenStore;
    protected final PcodeEncoder pscodeEncoder;
    protected final long timeinterval;
    protected final String requestTokenSalt;

    public SimpleRequestTokenValidator(RequestTokenStore requestTokenStore, PcodeEncoder pscodeEncoder, long timeinterval, String requestTokenSalt) {
        this.requestTokenStore = requestTokenStore;
        this.pscodeEncoder = pscodeEncoder;
        this.timeinterval = timeinterval;
        this.requestTokenSalt = requestTokenSalt;
    }

    @Override
    public boolean support(RequestToken requestToken) {
        return requestToken != null && (StringUtils.isBlank((CharSequence)requestToken.getProtocol()) || StringUtils.equalsIgnoreCase((CharSequence)requestToken.getProtocol(), (CharSequence)OnceProtocol.simple.name()));
    }

    @Override
    public void validate(RequestToken requestToken) throws II11iIiI {
        if (requestToken != null) {
            this.isValidTimestamp(requestToken.getCreateTime());
            this.isValidNonce(requestToken.getToken());
            this.isValidSign(requestToken);
        }
    }

    protected void isValidTimestamp(Long timestamp) {
        boolean bl;
        boolean bl2 = bl = timestamp != null && Math.abs(System.currentTimeMillis() - timestamp) <= this.timeinterval;
        if (!bl) {
            this.logger.error(false, "\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u65f6\u95f4\u6233\u4e0d\u5408\u6cd5");
            throw new II11iIiI("\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u65f6\u95f4\u6233\u4e0d\u5408\u6cd5");
        }
    }

    protected void isValidNonce(String nonce) {
        boolean bl;
        RequestToken requestToken = this.requestTokenStore.getToken(nonce);
        boolean bl2 = bl = StringUtils.isNotBlank((CharSequence)nonce) && (requestToken == null || requestToken.isExpired());
        if (!bl) {
            this.logger.error(false, "\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u5df2\u7ecf\u88ab\u4f7f\u7528\u8fc7");
            throw new II11iIiI("\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u5df2\u7ecf\u88ab\u4f7f\u7528\u8fc7");
        }
    }

    protected void isValidSign(RequestToken requestTokenFromRequest) {
        boolean bl = this.pscodeEncoder.matches(this.getRequestTokenAsStr(requestTokenFromRequest), requestTokenFromRequest.getSign());
        if (!bl) {
            this.logger.error(false, "\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u7b7e\u540d\u6458\u8981\u4e0d\u5408\u6cd5");
            throw new II11iIiI("\u9632\u91cd\u653e\u62e6\u622a\uff1a\u8bf7\u6c42\u4ee4\u724c\u7b7e\u540d\u6458\u8981\u4e0d\u5408\u6cd5");
        }
    }

    protected String getRequestTokenAsStr(RequestToken requestTokenFromRequest) {
        return String.join((CharSequence)",", requestTokenFromRequest.getCreateTime().toString(), requestTokenFromRequest.getToken());
    }
}

