/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.security.oncetoken.support;

import cn.aotcloud.exception.BaseExceptionEmpty;
import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.security.oncetoken.OnceProtocol;
import cn.aotcloud.security.oncetoken.RequestToken;
import cn.aotcloud.security.oncetoken.RequestTokenHandler;
import cn.aotcloud.security.oncetoken.RequestTokenParser;
import cn.aotcloud.security.oncetoken.RequestTokenStore;
import cn.aotcloud.security.oncetoken.RequestTokenValidator;
import cn.aotcloud.security.oncetoken.support.II11iIiI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class DefaultRequestTokenHandler
implements RequestTokenHandler,
ApplicationEventPublisherAware {
    private RequestTokenStore requestTokenStore;
    private ApplicationEventPublisher applicationEventPublisher;
    private RequestTokenParser requestTokenParser;
    private RequestTokenValidator requestTokenValidator;
    private List<OnceProtocol> supportedProtocols;

    public DefaultRequestTokenHandler(RequestTokenStore requestTokenStore, RequestTokenValidator requestTokenValidator) {
        this.requestTokenStore = requestTokenStore;
        this.requestTokenValidator = requestTokenValidator;
        this.requestTokenParser = new II11iIiI(this.supportedProtocols);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void validate(HttpServletRequest request) throws cn.aotcloud.security.oncetoken.II11iIiI {
        RequestToken requestToken = this.parseRequestToken(request);
        try {
            this.requestTokenValidator.validate(requestToken);
            this.requestTokenStore.save(requestToken);
        }
        catch (cn.aotcloud.security.oncetoken.II11iIiI iI11iIiI) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new cn.aotcloud.security.oncetoken.II11iIiI.II11iIiI(requestToken != null ? requestToken : RequestToken.ILLEGAL_REQUEST_TOKEN));
            throw new BaseExceptionEmpty(ExceptionUtil.getMessage(iI11iIiI));
        }
    }

    protected RequestToken parseRequestToken(HttpServletRequest request) {
        return this.requestTokenParser.parse(request);
    }
}

