/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.retry;

import cn.aotcloud.retry.Attempt;
import cn.aotcloud.retry.AttemptTimeLimiter;
import cn.aotcloud.retry.BlockStrategy;
import cn.aotcloud.retry.RetryException;
import cn.aotcloud.retry.RetryListener;
import cn.aotcloud.retry.StopStrategy;
import cn.aotcloud.retry.WaitStrategy;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

public final class Retryer<V> {
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final BlockStrategy blockStrategy;
    private final AttemptTimeLimiter<V> attemptTimeLimiter;
    private final Predicate<Attempt<V>> rejectionPredicate;
    private final Collection<RetryListener> listeners;

    public Retryer(@Nonnull StopStrategy stopStrategy, @Nonnull WaitStrategy waitStrategy, @Nonnull Predicate<Attempt<V>> rejectionPredicate) {
        this(cn.aotcloud.retry.II11iIiI.II11iIiI(), stopStrategy, waitStrategy, cn.aotcloud.retry.I111ii1I.II11iIiI(), rejectionPredicate);
    }

    public Retryer(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter, @Nonnull StopStrategy stopStrategy, @Nonnull WaitStrategy waitStrategy, @Nonnull Predicate<Attempt<V>> rejectionPredicate) {
        this(attemptTimeLimiter, stopStrategy, waitStrategy, cn.aotcloud.retry.I111ii1I.II11iIiI(), rejectionPredicate);
    }

    public Retryer(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter, @Nonnull StopStrategy stopStrategy, @Nonnull WaitStrategy waitStrategy, @Nonnull BlockStrategy blockStrategy, @Nonnull Predicate<Attempt<V>> rejectionPredicate) {
        this(attemptTimeLimiter, stopStrategy, waitStrategy, blockStrategy, rejectionPredicate, new ArrayList<RetryListener>());
    }

    @Beta
    public Retryer(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter, @Nonnull StopStrategy stopStrategy, @Nonnull WaitStrategy waitStrategy, @Nonnull BlockStrategy blockStrategy, @Nonnull Predicate<Attempt<V>> rejectionPredicate, @Nonnull Collection<RetryListener> listeners) {
        Preconditions.checkNotNull(attemptTimeLimiter, (Object)"timeLimiter may not be null");
        Preconditions.checkNotNull((Object)stopStrategy, (Object)"stopStrategy may not be null");
        Preconditions.checkNotNull((Object)waitStrategy, (Object)"waitStrategy may not be null");
        Preconditions.checkNotNull((Object)blockStrategy, (Object)"blockStrategy may not be null");
        Preconditions.checkNotNull(rejectionPredicate, (Object)"rejectionPredicate may not be null");
        Preconditions.checkNotNull(listeners, (Object)"listeners may not null");
        this.attemptTimeLimiter = attemptTimeLimiter;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.blockStrategy = blockStrategy;
        this.rejectionPredicate = rejectionPredicate;
        this.listeners = listeners;
    }

    public V call(Callable<V> callable) throws ExecutionException, RetryException {
        long l = System.nanoTime();
        int n = 1;
        while (true) {
            Attempt<Object> attempt;
            try {
                V v = this.attemptTimeLimiter.call(callable);
                attempt = new I111ii1I<V>(v, n, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l));
            }
            catch (Throwable throwable) {
                attempt = new II11iIiI(throwable, n, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l));
            }
            for (RetryListener retryListener : this.listeners) {
                retryListener.onRetry(attempt);
            }
            if (!this.rejectionPredicate.apply(attempt)) {
                return (V)attempt.get();
            }
            if (this.stopStrategy.shouldStop(attempt)) {
                throw new RetryException(n, attempt);
            }
            long l2 = this.waitStrategy.computeSleepTime(attempt);
            try {
                this.blockStrategy.block(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RetryException(n, attempt);
            }
            ++n;
        }
    }

    public i111IiI1<V> wrap(Callable<V> callable) {
        return new i111IiI1(this, callable);
    }

    public static class i111IiI1<X>
    implements Callable<X> {
        private Retryer<X> II11iIiI;
        private Callable<X> I111ii1I;

        private i111IiI1(Retryer<X> retryer, Callable<X> callable) {
            this.II11iIiI = retryer;
            this.I111ii1I = callable;
        }

        @Override
        public X call() throws ExecutionException, RetryException {
            return this.II11iIiI.call(this.I111ii1I);
        }
    }

    @Immutable
    static final class II11iIiI<R>
    implements Attempt<R> {
        private final ExecutionException II11iIiI;
        private final long I111ii1I;
        private final long i111IiI1;

        public II11iIiI(Throwable throwable, long l, long l2) {
            this.II11iIiI = new ExecutionException(throwable);
            this.I111ii1I = l;
            this.i111IiI1 = l2;
        }

        @Override
        public R get() throws ExecutionException {
            throw this.II11iIiI;
        }

        @Override
        public boolean hasResult() {
            return false;
        }

        @Override
        public boolean hasException() {
            return true;
        }

        @Override
        public R getResult() throws IllegalStateException {
            throw new IllegalStateException("The attempt resulted in an exception, not in a result");
        }

        @Override
        public Throwable getExceptionCause() throws IllegalStateException {
            return this.II11iIiI.getCause();
        }

        @Override
        public long getAttemptNumber() {
            return this.I111ii1I;
        }

        @Override
        public long getDelaySinceFirstAttempt() {
            return this.i111IiI1;
        }
    }

    @Immutable
    static final class I111ii1I<R>
    implements Attempt<R> {
        private final R II11iIiI;
        private final long I111ii1I;
        private final long i111IiI1;

        public I111ii1I(R r, long l, long l2) {
            this.II11iIiI = r;
            this.I111ii1I = l;
            this.i111IiI1 = l2;
        }

        @Override
        public R get() throws ExecutionException {
            return this.II11iIiI;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean hasException() {
            return false;
        }

        @Override
        public R getResult() throws IllegalStateException {
            return this.II11iIiI;
        }

        @Override
        public Throwable getExceptionCause() throws IllegalStateException {
            throw new IllegalStateException("The attempt resulted in a result, not in an exception");
        }

        @Override
        public long getAttemptNumber() {
            return this.I111ii1I;
        }

        @Override
        public long getDelaySinceFirstAttempt() {
            return this.i111IiI1;
        }
    }
}

