/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.filter;

import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.smcrypto.Sm4Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class BaseAuthenticationFilter
extends OncePerRequestFilter {
    protected static LoggerHandle logger = new LoggerHandle(BaseAuthenticationFilter.class);

    protected String getAlreadyFilteredAttributeName() {
        return BaseAuthenticationFilter.class.getName() + ".FILTERED";
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static String getAccessToken(HttpServletRequest request, String accessTokenAttrName) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            return (String)httpSession.getAttribute(accessTokenAttrName);
        }
        return null;
    }

    public static String getName(String encryptHex) {
        String string = "\u672a\u77e5\u767b\u5f55\u8ba4\u8bc1";
        try {
            string = Sm4Utils.ECB.decryptToText((String)encryptHex, (String)"dc174a9a612f06107738f8d5b702c2fc");
        }
        catch (InvalidCryptoDataException invalidCryptoDataException) {
            logger.error("\u89e3\u5bc6AuthType\u65f6\u53d1\u751fInvalidCryptoDataException\u5f02\u5e38");
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.error("\u89e3\u5bc6AuthType\u65f6\u53d1\u751fInvalidKeyException\u5f02\u5e38");
        }
        return string;
    }

    public static void main(String[] args) {
        String string = System.getProperty("os.arch");
        System.out.println(string);
    }

    public static enum AuthType {
        ISC_SSO(1, BaseAuthenticationFilter.getName("8272E04F41E5053BA5D9FB9A3A2F7FD915A902A2651AF4AC3D60EABBD2ADDB62")),
        ISC_AUTHAPI(2, BaseAuthenticationFilter.getName("4B6CCF9C464718B43335C25A99BB6EE8FA7B3A925FD7366E2DD80FDEE0A48CF7")),
        WX_QRCODE(3, BaseAuthenticationFilter.getName("AE1B99E2FD391D50DFB32ADFCE699BB498D7D0927A1487E143009E4E979AAC17")),
        PL_QRCODE(4, BaseAuthenticationFilter.getName("6A2E0559E8F56C329928333D9E23564A98D7D0927A1487E143009E4E979AAC17"));

        private final int type;
        private final String desc;

        private AuthType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

