/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.rsfilter;

import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import cn.aotcloud.oauth2.altu.oauth2.common.message.OAuthResponse;
import cn.aotcloud.oauth2.altu.oauth2.common.message.types.ParameterStyle;
import cn.aotcloud.oauth2.altu.oauth2.rs.request.OAuthAccessResourceRequest;
import cn.aotcloud.oauth2.altu.oauth2.rs.response.OAuthRSResponse;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.OAuthDecision;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.OAuthRSProvider;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.i111IiI1;
import cn.aotcloud.utils.HttpServletUtil;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class I111ii1I
implements Filter {
    public static final String II11iIiI = "oauth.rs.provider-class";
    public static final String I111ii1I = "oauth.rs.realm";
    public static final String i111IiI1 = "OAuth Protected Service";
    public static final String i1iI111I = "oauth.rs.tokens";
    public static final ParameterStyle iI1II1Ii = ParameterStyle.HEADER;
    private static final String I1iIiI1I = ",";
    private String Iii11I11;
    private OAuthRSProvider iiIII11I;
    private ParameterStyle[] i11I1I1i;

    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        this.iiIII11I = cn.aotcloud.oauth2.altu.oauth2.rsfilter.i111IiI1.II11iIiI(filterConfig.getServletContext(), II11iIiI, OAuthRSProvider.class);
        this.Iii11I11 = filterConfig.getServletContext().getInitParameter(I111ii1I);
        if (cn.aotcloud.oauth2.altu.oauth2.rsfilter.i111IiI1.II11iIiI(this.Iii11I11)) {
            this.Iii11I11 = i111IiI1;
        }
        if (cn.aotcloud.oauth2.altu.oauth2.rsfilter.i111IiI1.II11iIiI(string = filterConfig.getServletContext().getInitParameter(i1iI111I))) {
            this.i11I1I1i = new ParameterStyle[]{iI1II1Ii};
        } else {
            String[] stringArray = string.split(I1iIiI1I);
            if (stringArray != null && stringArray.length > 0) {
                this.i11I1I1i = new ParameterStyle[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.i11I1I1i[i] = ParameterStyle.valueOf(stringArray[i]);
                }
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            OAuthAccessResourceRequest oAuthAccessResourceRequest = new OAuthAccessResourceRequest(httpServletRequest, this.i11I1I1i);
            String string = oAuthAccessResourceRequest.getAccessToken();
            OAuthDecision oAuthDecision = this.iiIII11I.validateRequest(this.Iii11I11, string, httpServletRequest);
            final Principal principal = oAuthDecision.getPrincipal();
            request = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return principal != null ? principal.getName() : null;
                }

                public Principal getUserPrincipal() {
                    return principal;
                }
            };
            request.setAttribute("client_id", (Object)oAuthDecision.getOAuthClient().getClientId());
            chain.doFilter(request, response);
            return;
        }
        catch (OAuthSystemException oAuthSystemException) {
            throw new ServletException((Throwable)oAuthSystemException);
        }
        catch (OAuthProblemException oAuthProblemException) {
            this.II11iIiI(httpServletResponse, oAuthProblemException);
            return;
        }
    }

    public void destroy() {
    }

    private void II11iIiI(HttpServletResponse httpServletResponse, OAuthProblemException oAuthProblemException) throws IOException, ServletException {
        OAuthResponse oAuthResponse = null;
        try {
            if (cn.aotcloud.oauth2.altu.oauth2.rsfilter.i111IiI1.II11iIiI(oAuthProblemException.getError())) {
                oAuthResponse = OAuthRSResponse.errorResponse(401).setRealm(this.Iii11I11).buildHeaderMessage();
            } else {
                int n = 401;
                if (oAuthProblemException.getError().equals("invalid_request")) {
                    n = 400;
                } else if (oAuthProblemException.getError().equals("insufficient_scope")) {
                    n = 403;
                }
                oAuthResponse = OAuthRSResponse.errorResponse(n).setRealm(this.Iii11I11).setError(oAuthProblemException.getError()).setErrorDescription(oAuthProblemException.getDescription()).setErrorUri(oAuthProblemException.getUri()).buildHeaderMessage();
            }
            HttpServletUtil.addHeader(httpServletResponse, "WWW-Authenticate", oAuthResponse.getHeader("WWW-Authenticate"));
            HttpServletUtil.sendError(httpServletResponse, oAuthResponse.getResponseStatus());
        }
        catch (OAuthSystemException oAuthSystemException) {
            throw new ServletException((Throwable)oAuthSystemException);
        }
    }
}

