/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2;

import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import cn.aotcloud.utils.HttpServletUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.FileCopyUtils;

public class ZuulUrlHelper {
    private static final Logger logger = LoggerFactory.getLogger(ZuulUrlHelper.class);

    public static String getRequestUrl(HttpServletRequest request) {
        String string;
        String string2 = HttpServletUtil.getHeader(request, "X-Acloud-Protocol");
        if (string2 == null) {
            string2 = HttpServletUtil.getHeader(request, "x-forwarded-proto");
        }
        if (string2 == null) {
            string2 = request.getScheme();
        }
        if ((string = HttpServletUtil.getHeader(request, "X-Acloud-Request-Uri-Prefix")) == null) {
            string = "";
        }
        String string3 = HttpServletUtil.getHeader(request, "x-forwarded-host");
        String string4 = ZuulUrlHelper.getServiceId(request);
        String string5 = null;
        string5 = !StringUtils.isEmpty((CharSequence)string3) && !StringUtils.isEmpty((CharSequence)string4) ? string2 + "://" + string3 + string + string4 + request.getRequestURI() : string2 + "://" + request.getServerName() + ":" + request.getServerPort() + string + request.getContextPath() + request.getRequestURI();
        return string5;
    }

    public static String getDefaultLogoutSuccessUrl(HttpServletRequest request) {
        String string = ZuulUrlHelper.getServiceId(request);
        if (!StringUtils.isEmpty((CharSequence)string)) {
            return string + "/";
        }
        return "/";
    }

    public static String getLogoutUrl(HttpServletRequest request, String logoutPath) {
        String string = HttpServletUtil.getHeader(request, "X-Acloud-Protocol");
        if (string == null) {
            string = HttpServletUtil.getHeader(request, "x-forwarded-proto");
        }
        if (string == null) {
            string = request.getScheme();
        }
        String string2 = HttpServletUtil.getHeader(request, "x-forwarded-host");
        String string3 = ZuulUrlHelper.getServiceId(request);
        String string4 = null;
        string4 = !StringUtils.isEmpty((CharSequence)string2) && !StringUtils.isEmpty((CharSequence)string3) ? string + "://" + string2 + string3 + logoutPath : string + "://" + request.getServerName() + ":" + request.getServerPort() + logoutPath;
        return string4;
    }

    public static String getRedirectUri(HttpServletRequest request, String redirectUri) {
        if (StringUtils.isEmpty((CharSequence)redirectUri)) {
            IllegalStateException illegalStateException = new IllegalStateException("\u65e0\u6cd5\u83b7\u5f97\u91cd\u5b9a\u5411URL\u5730\u5740\u3002");
            logger.error(illegalStateException.getMessage());
        }
        return redirectUri;
    }

    public static String getServiceId(HttpServletRequest request) {
        String string = HttpServletUtil.getHeader(request, "x-forwarded-prefix");
        return string;
    }

    public static void loginRedirect(HttpServletResponse servletResponse, String url) throws IOException, ServletException {
        try {
            HttpServletUtil.setStatus(servletResponse, HttpStatus.UNAUTHORIZED.value());
            HttpServletUtil.setHeader(servletResponse, "Strict-Transport-Security", "max-age=31536000; includeSubDomains;preload");
            FileCopyUtils.copy((String)url, (Writer)HttpServletUtil.getPrintWriter(servletResponse));
        }
        catch (OAuthSystemException oAuthSystemException) {
            throw new ServletException((Throwable)oAuthSystemException);
        }
    }

    public static void responseEmpty(HttpServletResponse servletResponse) throws IOException {
        HttpServletUtil.setStatus(servletResponse, HttpStatus.FORBIDDEN.value());
        HttpServletUtil.setCharacterEncoding(servletResponse, "UTF-8");
        HttpServletUtil.setHeader(servletResponse, "Strict-Transport-Security", "max-age=31536000; includeSubDomains;preload");
        FileCopyUtils.copy((String)"", (Writer)HttpServletUtil.getPrintWriter(servletResponse));
    }

    public static void responseUser(HttpServletResponse servletResponse, Map<String, Object> user, Object accessToken) throws IOException {
        servletResponse.setStatus(HttpStatus.OK.value());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userInfo", user);
        hashMap.put("accessToken", accessToken);
        HttpServletUtil.setCharacterEncoding(servletResponse, "UTF-8");
        HttpServletUtil.setContentType(servletResponse, "application/json; charset=UTF-8");
        HttpServletUtil.setHeader(servletResponse, "Strict-Transport-Security", "max-age=31536000; includeSubDomains;preload");
        FileCopyUtils.copy((String)JSONObject.toJSONString(hashMap), (Writer)HttpServletUtil.getPrintWriter(servletResponse));
    }
}

