/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2;

import cn.aotcloud.oauth2.altu.oauth2.rsfilter.OAuthDecision;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.SimpleOAuthDecision;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.SimplePrincipal;
import java.security.Principal;
import java.util.Map;
import org.springframework.core.NamedThreadLocal;

public class OAuthDecisionHolder {
    private static final NamedThreadLocal<OAuthDecision> NAMED_THREAD_LOCAL = new NamedThreadLocal("OAuth Decision Thread Local");

    public static void setOAuthDecision(OAuthDecision decision) {
        NAMED_THREAD_LOCAL.set((Object)decision);
    }

    public static void remove() {
        NAMED_THREAD_LOCAL.remove();
    }

    public static OAuthDecision getOAuthDecision() {
        return (OAuthDecision)NAMED_THREAD_LOCAL.get();
    }

    public static String getAccessToken() {
        return OAuthDecisionHolder.getOAuthDecision() != null ? ((SimpleOAuthDecision)OAuthDecisionHolder.getOAuthDecision()).getAccessToken() : null;
    }

    public static String getClientId() {
        return OAuthDecisionHolder.getOAuthDecision() != null ? OAuthDecisionHolder.getOAuthDecision().getOAuthClient().getClientId() : null;
    }

    public static Principal getPrincipal() {
        return OAuthDecisionHolder.getOAuthDecision() != null ? OAuthDecisionHolder.getOAuthDecision().getPrincipal() : null;
    }

    public static String getUid() {
        return OAuthDecisionHolder.getPrincipal() != null ? OAuthDecisionHolder.getPrincipal().getName() : null;
    }

    public static Map<String, Object> getPrincipalAttributes() {
        return OAuthDecisionHolder.getPrincipal() != null ? ((SimplePrincipal)OAuthDecisionHolder.getPrincipal()).getAttributes() : null;
    }

    public static Object getPrincipalAttribute(String name) {
        return OAuthDecisionHolder.getPrincipalAttributes() != null ? OAuthDecisionHolder.getPrincipalAttributes().get(name) : null;
    }
}

