/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.plus;

import cn.aotcloud.mybatis.annotation.EncryptedColumn;
import cn.aotcloud.mybatis.annotation.EncryptedTable;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class ColumnEncryptInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    protected Pattern PARAM_PAIRS_RE = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        super.beforePrepare(sh, connection, transactionTimeout);
    }

    public void beforeGetBoundSql(StatementHandler sh) {
        super.beforeGetBoundSql(sh);
    }

    public void beforeQuery(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (Objects.isNull(parameterObject)) {
            return;
        }
        if (!(parameterObject instanceof Map)) {
            return;
        }
        Map map = (Map)parameterObject;
        Set set = map.values().stream().collect(Collectors.toSet());
        for (Object t : set) {
            if (t instanceof AbstractWrapper || t instanceof String || !this.needToDecrypt(t.getClass())) continue;
            this.encryptEntity(t);
        }
    }

    public void beforeUpdate(Executor executor, MappedStatement mappedStatement, Object parameterObject) throws SQLException {
        Object v;
        if (Objects.isNull(parameterObject)) {
            return;
        }
        if (!(parameterObject instanceof Map)) {
            if (this.needToDecrypt(parameterObject.getClass())) {
                this.encryptEntity(parameterObject);
            }
            return;
        }
        Map map = (Map)parameterObject;
        if (map.containsKey("et") && null != (v = map.get("et"))) {
            if (this.needToDecrypt(v.getClass())) {
                this.encryptEntity(v);
            }
            return;
        }
        if (map.containsKey("entity") && null != (v = map.get("entity"))) {
            if (this.needToDecrypt(v.getClass())) {
                this.encryptEntity(v);
            }
            return;
        }
        if (map.containsKey("ew") && null != (v = map.get("ew"))) {
            Class clazz;
            if (v instanceof Update && v instanceof AbstractWrapper && this.needToDecrypt(clazz = mappedStatement.getParameterMap().getType())) {
                this.encryptWrapper(clazz, v);
            }
            return;
        }
    }

    private boolean needToDecrypt(Class<?> objectClass) {
        EncryptedTable encryptedTable = (EncryptedTable)AnnotationUtils.findAnnotation(objectClass, EncryptedTable.class);
        return Objects.nonNull(encryptedTable);
    }

    private void encryptEntity(Object parameter) {
        Field[] fieldArray;
        Class<?> clazz = parameter.getClass();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            EncryptedColumn encryptedColumn = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(encryptedColumn)) continue;
            field.setAccessible(true);
            Object object = null;
            try {
                object = field.get(parameter);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            if (!(object instanceof String)) continue;
            String string = (String)object;
            try {
                field.set(parameter, this.encryptData(string));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void encryptWrapper(Class<?> entityClass, Object ewParam) {
        Object v;
        String string;
        Matcher matcher;
        Object object;
        String string2;
        AbstractWrapper abstractWrapper = (AbstractWrapper)ewParam;
        String string3 = abstractWrapper.getSqlSet();
        if (StringUtils.isBlank((CharSequence)string3)) {
            return;
        }
        String[] stringArray = string3.split(",");
        HashMap hashMap = new HashMap(stringArray.length);
        Arrays.stream(stringArray).forEach(el -> {
            String[] stringArray = el.split("=");
            hashMap.put(stringArray[0], stringArray[1]);
        });
        Field[] fieldArray = entityClass.getDeclaredFields();
        AccessibleObject[] accessibleObjectArray = fieldArray;
        int n = accessibleObjectArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = accessibleObjectArray[i];
            EncryptedColumn object2 = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(object2) || !StringUtils.isNotBlank((CharSequence)(string2 = (String)hashMap.get(object = field.getName()))) || !(matcher = this.PARAM_PAIRS_RE.matcher(string2)).matches()) continue;
            string = matcher.group(1);
            v = abstractWrapper.getParamNameValuePairs().get(string);
            abstractWrapper.getParamNameValuePairs().put(string, this.encryptData(v.toString()));
        }
        for (AccessibleObject accessibleObject : accessibleObjectArray = entityClass.getDeclaredMethods()) {
            object = ((Method)accessibleObject).getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(object) || !(matcher = this.PARAM_PAIRS_RE.matcher(string2 = (String)hashMap.get(((Method)accessibleObject).getName()))).matches()) continue;
            string = matcher.group(1);
            v = abstractWrapper.getParamNameValuePairs().get(string);
            abstractWrapper.getParamNameValuePairs().put(string, this.encryptData(v.toString()));
        }
    }

    public abstract String encryptData(String var1);
}

