/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.mybatis.plus;

import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.mybatis.annotation.EncryptedColumn;
import cn.aotcloud.mybatis.annotation.EncryptedTable;
import cn.aotcloud.smcrypto.util.StringUtils;
import cn.aotcloud.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class ColumnDecryptInterceptor
implements Interceptor {
    protected LoggerHandle logger = new LoggerHandle(this.getClass());

    public Object intercept(Invocation invocation) throws Throwable {
        Object object = invocation.proceed();
        if (Objects.isNull(object)) {
            return null;
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (!arrayList.isEmpty() && this.needToDecrypt(arrayList.get(0))) {
                for (Object e : arrayList) {
                    this.decrypt(e);
                }
            }
        } else if (this.needToDecrypt(object)) {
            this.decrypt(object);
        }
        return object;
    }

    private boolean needToDecrypt(Object object) {
        Class<?> clazz = object.getClass();
        EncryptedTable encryptedTable = (EncryptedTable)AnnotationUtils.findAnnotation(clazz, EncryptedTable.class);
        return Objects.nonNull(encryptedTable);
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    private <T> T decrypt(T result) throws Exception {
        Field[] fieldArray;
        Class<?> clazz = result.getClass();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            EncryptedColumn encryptedColumn = field.getAnnotation(EncryptedColumn.class);
            if (Objects.isNull(encryptedColumn)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (!(object instanceof String)) continue;
            String string = (String)object;
            String string2 = this.decryptData(clazz.getSimpleName(), field.getName(), result, string);
            field.set(result, string2);
        }
        return result;
    }

    public String getKey(Object result) {
        String string = this.getFieldStringVal(result, "agentId");
        if (string == null) {
            string = this.getFieldStringVal(result, "id");
        }
        return string;
    }

    public String getFieldStringVal(Object result, String key) {
        if (result != null && StringUtils.isNotBlank((CharSequence)key)) {
            try {
                Object object = ReflectionUtils.getFieldValue(result, key);
                if (object != null && object instanceof String) {
                    return (String)object;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                this.logger.taskInfo("[Scheduled]", "\u83b7\u53d6\u8bc6\u522bID\u5f02\u5e38:{}", ExceptionUtil.getMessage(exception));
            }
        }
        return null;
    }

    public abstract String decryptData(String var1, String var2, Object var3, String var4);
}

