/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.HttpTrustUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private PoolingHttpClientConnectionManager connManager;

    public PoolingHttpClientConnectionManager getConnManager() {
        return this.connManager;
    }

    public RestTemplate getSSLRestTemplate(int connectTimeout, int readTimeout, int connectionRequestTimeout, int maxConnTotal, int maxConnPerRoute) {
        SSLContext sslContext = this.getSSLContext();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
        this.connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.connManager).setMaxConnTotal(maxConnTotal).setMaxConnPerRoute(maxConnPerRoute);
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        clientHttpRequestFactory.setConnectTimeout(connectTimeout);
        clientHttpRequestFactory.setReadTimeout(readTimeout);
        clientHttpRequestFactory.setConnectionRequestTimeout(connectionRequestTimeout);
        clientHttpRequestFactory.setBufferRequestBody(false);
        RestTemplate restTemplate = this.getUTF8restTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory);
        this.closeConnectionsScheduled(this.connManager);
        return restTemplate;
    }

    public RestTemplate getTrustTemplate() {
        SSLContext sslContext = this.getSSLContext();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
        this.connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = this.getUTF8restTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory);
        this.closeConnectionsScheduled(this.connManager);
        return restTemplate;
    }

    public RestTemplate getUTF8restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (converter instanceof StringHttpMessageConverter) {
                StringHttpMessageConverter messageConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
                messageConverters.add(messageConverter);
                continue;
            }
            messageConverters.add(converter);
        }
        restTemplate.setMessageConverters(messageConverters);
        return restTemplate;
    }

    private SSLContext getSSLContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            X509TrustManager manager = HttpTrustUtil.createX509TrustManager();
            sc.init(null, new TrustManager[]{manager}, null);
            return sc;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void closeConnectionsScheduled(final PoolingHttpClientConnectionManager connManager) {
        ScheduledExecutorService monitorExecutor = Executors.newScheduledThreadPool(1);
        monitorExecutor.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                connManager.closeExpiredConnections();
                connManager.closeIdleConnections(5L, TimeUnit.SECONDS);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public static <T> ResponseEntity<T> postForEntity(RestTemplate restTemplate, String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return restTemplate.postForEntity(url, request, responseType, uriVariables);
    }
}

