/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.BaseCodeUtils;
import cn.aotcloud.utils.IOUtils;
import cn.aotcloud.utils.QrConts;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.springframework.core.io.ClassPathResource;

public class QrCodeUtils
extends BaseCodeUtils {
    public static BufferedImage createQRCodeImage(String content, QrConts qrConts, boolean defaultLogo, boolean defaultFrame, boolean needCompress, int targetRgb, boolean changeRgb) throws WriterException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrConts.getQrSize(), qrConts.getQrSize(), hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        if (width < Integer.MAX_VALUE && height < Integer.MAX_VALUE) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? (changeRgb ? targetRgb : -16777216) : -1);
                }
            }
        }
        InputStream logoInput = null;
        try {
            if (!defaultLogo) {
                return image;
            }
            ClassPathResource logoResource = new ClassPathResource("qrlogo/" + qrConts.getLogoSize() + ".png");
            logoInput = logoResource.getInputStream();
            QrCodeUtils.insertQRCodeImageLogo(image, logoInput, qrConts, needCompress);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(logoInput);
        }
        image = QrCodeUtils.drawQRCodeImageFrame(image, qrConts, defaultFrame, changeRgb, targetRgb);
        return image;
    }

    public static BufferedImage createQRCodeImage(String content, InputStream logoInput, QrConts qrConts, boolean defaultLogo, boolean defaultFrame, boolean needCompress, int targetRgb, boolean changeRgb) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrConts.getQrSize(), qrConts.getQrSize(), hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        if (width < Integer.MAX_VALUE && height < Integer.MAX_VALUE) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? (changeRgb ? targetRgb : -16777216) : -1);
                }
            }
        }
        QrCodeUtils.insertQRCodeImageLogo(image, logoInput, qrConts, needCompress);
        image = QrCodeUtils.drawQRCodeImageFrame(image, qrConts, defaultFrame, changeRgb, targetRgb);
        return image;
    }

    private static void insertQRCodeImageLogo(BufferedImage source, InputStream logoInput, QrConts qrConts, boolean needCompress) throws IOException {
        if (logoInput == null) {
            return;
        }
        Image src = ImageIO.read(logoInput);
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > qrConts.getLogoSize()) {
                width = qrConts.getLogoSize();
            }
            if (height > qrConts.getLogoSize()) {
                height = qrConts.getLogoSize();
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (qrConts.getQrSize() - width) / 2;
        int y = (qrConts.getQrSize() - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
        IOUtils.closeQuietly((InputStream)logoInput);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage drawQRCodeImageFrame(BufferedImage image, QrConts qrConts, boolean defaultFrame, boolean changeRgb, int targetRgb) {
        if (!defaultFrame) return image;
        ClassPathResource frameResource = new ClassPathResource("qrframe/" + qrConts.getFrameSize() + ".png");
        try (InputStream frameInputStream = frameResource.getInputStream();){
            BufferedImage frame = ImageIO.read(frameInputStream);
            if (changeRgb) {
                frame = QrCodeUtils.changeQRCodeImageRGB(frame, changeRgb, targetRgb);
            }
            Graphics2D g = frame.createGraphics();
            g.drawImage(image, (frame.getWidth() - image.getWidth()) / 2, (frame.getHeight() - image.getHeight()) / 2, image.getWidth(), image.getHeight(), null);
            g.dispose();
            IOUtils.closeQuietly((InputStream)frameInputStream);
            BufferedImage bufferedImage = frame;
            return bufferedImage;
        }
        catch (IOException e) {
            logger.error(e);
        }
        return image;
    }

    public static BufferedImage changeQRCodeImageRGB(BufferedImage image, boolean changeRgb, int targetRgb) {
        if (!changeRgb) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int critical = 5;
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        int pixel = image.getRGB(critical, critical);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (width < Integer.MAX_VALUE && height < Integer.MAX_VALUE) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int nowPixel = image.getRGB(x, y);
                    int p = pixel != nowPixel ? targetRgb : nowPixel;
                    g.setColor(new Color(p));
                    g.fillRect(x, y, 1, 1);
                }
            }
        }
        return bufferedImage;
    }

    public static int getRGBFromHex(String hexStr) {
        int[] rgbArray = QrCodeUtils.getRGBArrayFromHex(hexStr);
        return QrCodeUtils.getIntFromRGBArray(rgbArray[0], rgbArray[1], rgbArray[2]);
    }

    public static int[] getRGBArrayFromHex(String hexStr) {
        if (hexStr != null && !"".equals(hexStr) && hexStr.length() == 7) {
            int[] rgb = new int[]{Integer.valueOf(hexStr.substring(1, 3), 16), Integer.valueOf(hexStr.substring(3, 5), 16), Integer.valueOf(hexStr.substring(5, 7), 16)};
            return rgb;
        }
        return null;
    }

    public static int getIntFromRGBArray(int Red, int Green, int Blue) {
        Red = Red << 16 & 0xFF0000;
        Green = Green << 8 & 0xFF00;
        return 0xFF000000 | Red | Green | (Blue &= 0xFF);
    }
}

