/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinYinUtil {
    private static Logger logger = LoggerFactory.getLogger(PinYinUtil.class);
    private static final HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();

    public static String getPinYin(String chinese) {
        char[] spell = chinese.toCharArray();
        String pinYin = "";
        for (int i = 0; i < spell.length; ++i) {
            if (spell[i] >= '\u4e00' && spell[i] <= '\u9fbb') {
                try {
                    pinYin = pinYin + PinyinHelper.toHanyuPinyinStringArray((char)spell[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    logger.error("\u83b7\u53d6\u6c49\u5b57\u62fc\u97f3\u65f6\u53d1\u751fBadHanyuPinyinOutputFormatCombination\u5f02\u5e38");
                }
                continue;
            }
            pinYin = pinYin + spell[i];
        }
        return pinYin;
    }

    public static String getFirstPinYin(String chinese) {
        return PinYinUtil.getPinYin(chinese).substring(0, 1);
    }

    public static String getFirstUpPinYin(String chinese) {
        return PinYinUtil.getFirstPinYin(chinese).toUpperCase();
    }

    private static final boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String captureName(String str) {
        char[] cs = str.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    static {
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

