/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.utils.HttpServletUtil;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class HttpRequestUtil {
    public static final String LOCALHOST = "localhost";
    public static final String LOCAL_127 = "127.0.0.1";
    public static final String LOCAL_IPV6 = "0:0:0:0:0:0:0:1";

    public static String getIPAddress(HttpServletRequest request, boolean xff) {
        if (xff) {
            String ipAddresses = HttpRequestUtil.getIPAddressFull(request);
            if (StringUtils.isBlank((CharSequence)ipAddresses) || StringUtils.equalsAnyIgnoreCase((CharSequence)ipAddresses, (CharSequence[])new CharSequence[]{"unknown", "null"})) {
                ipAddresses = request.getRemoteAddr();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)ipAddresses, (CharSequence)LOCAL_IPV6) ? LOCAL_127 : ipAddresses;
        }
        return request.getRemoteAddr();
    }

    private static String getIPAddressFull(HttpServletRequest request) {
        String ipAddresses = HttpServletUtil.getHeader(request, "X-Forwarded-For");
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = HttpServletUtil.getHeader(request, "Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = HttpServletUtil.getHeader(request, "WL-Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = HttpServletUtil.getHeader(request, "HTTP_CLIENT_IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = HttpServletUtil.getHeader(request, "X-Real-IP");
        }
        return ipAddresses;
    }

    public static boolean isLocalhostAddr(String location) {
        return LOCALHOST.equals(location) || LOCAL_127.equals(location) || LOCAL_IPV6.equals(location);
    }

    public static HttpServletRequest getHttpServletRequestFromThreadLocal() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        }
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getHeaderValue(HttpServletRequest request, String key, String defaultValue) {
        String value = HttpRequestUtil.getHeaderValue(request, key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getHeaderValue(HttpServletRequest httpRequest, String key) {
        String value = HttpServletUtil.getHeader(httpRequest, key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = value.replaceAll("(\r\n|\r|\n|\n\r)", "");
        }
        return value;
    }

    public static void addHttpHeaderValue(HttpServletResponse response, String name, String value) {
        response.addHeader(name, value);
    }

    public static void addHttpCookieValue(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static String getParameterValue(HttpServletRequest request, String key) {
        return StringEscapeUtils.escapeHtml4((String)WebUtils.findParameterValue((ServletRequest)request, (String)key));
    }

    public static String getParameterValue(HttpServletRequest request, String key, String defaultValue) {
        String value = HttpRequestUtil.getParameterValue(request, key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getRequestURL(HttpServletRequest request) {
        return request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
    }

    public static String getContentType(HttpServletRequest request) {
        return request.getContentType();
    }

    public static String getRemoteHost(HttpServletRequest request) {
        return request.getRemoteHost();
    }

    public static void setContentType(HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
    }

    public static void sendRedirect(HttpServletResponse response, String location) throws IOException {
        response.sendRedirect(location);
    }

    public static void setSessionAttribute(HttpSession session, String name, Object value) {
        if (session != null) {
            session.setAttribute(name, value);
        }
    }

    public static void setRequestAttribute(HttpServletRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }

    public static Object getRequestAttribute(HttpServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> parameterNames = HttpServletUtil.getParameterNames(request);
        while (parameterNames != null && parameterNames.hasMoreElements()) {
            String parameterName = parameterNames.nextElement();
            String parameterValue = HttpServletUtil.getParameter(request, parameterName);
            map.put(parameterName, parameterValue);
        }
        return map;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> headerNames = HttpServletUtil.getHeaderNames(request);
        while (headerNames != null && headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            String headerValue = HttpServletUtil.getHeader(request, headerName);
            map.put(headerName, headerValue);
        }
        return map;
    }

    public static void removeHttpSessionCookie(HttpServletRequest request, HttpServletResponse response, ServerProperties serverProperties) {
        Session.Cookie cookie = serverProperties.getServlet().getSession().getCookie();
        String name = StringUtils.isEmpty((CharSequence)cookie.getName()) ? "JSESSIONID" : cookie.getName();
        Cookie sessionCookie = new Cookie(name, "");
        if (cookie.getDomain() != null) {
            sessionCookie.setDomain(cookie.getDomain());
        }
        sessionCookie.setPath(cookie.getPath());
        sessionCookie.setMaxAge(0);
        if (cookie.getSecure() != null) {
            sessionCookie.setSecure(cookie.getSecure().booleanValue());
        }
        if (cookie.getHttpOnly() != null) {
            sessionCookie.setHttpOnly(cookie.getHttpOnly().booleanValue());
        }
        response.addCookie(sessionCookie);
    }

    public static String getBodyString(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try (ServletInputStream inputStream = request.getInputStream();){
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u83b7\u53d6\u8bf7\u6c42\u4f53\u5f02\u5e38");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return sb.toString();
    }

    public static boolean flashBackCheck(String param) {
        return !StringUtils.containsAnyIgnoreCase((CharSequence)param, (CharSequence[])new CharSequence[]{"..", "%", "&"});
    }

    public static boolean safeCheck(String param) {
        return !StringUtils.containsAnyIgnoreCase((CharSequence)param, (CharSequence[])new CharSequence[]{" or ", " insert ", " select ", " delete ", " update ", "script>", "alert(", "..", "%", "&"});
    }

    public static boolean safeCheck(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        map.putAll(HttpRequestUtil.getParameterMap(request));
        map.putAll(HttpRequestUtil.getHeaderMap(request));
        for (Map.Entry entry : map.entrySet()) {
            if (!StringUtils.containsAnyIgnoreCase((CharSequence)((CharSequence)entry.getValue()), (CharSequence[])new CharSequence[]{" or ", " insert ", " select ", " delete ", " update ", "script>", "alert(", "..", "%", "&"})) continue;
            return false;
        }
        return true;
    }
}

