/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.codecs.CSSCodec;
import cn.aotcloud.codecs.DefaultEncoder;
import cn.aotcloud.codecs.Encoder;
import cn.aotcloud.codecs.HTMLEntityCodec;
import cn.aotcloud.codecs.JavaScriptCodec;
import cn.aotcloud.codecs.MySQLCodec;
import cn.aotcloud.codecs.OracleCodec;
import cn.aotcloud.codecs.PercentCodec;
import cn.aotcloud.codecs.UnixCodec;
import cn.aotcloud.codecs.VBScriptCodec;
import cn.aotcloud.codecs.WindowsCodec;
import cn.aotcloud.codecs.XMLEntityCodec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;

public class CodecUtils {
    protected static final Logger logger = LoggerFactory.getLogger(CodecUtils.class);
    private static final Encoder encoder = new DefaultEncoder(Arrays.asList(new HTMLEntityCodec(), new PercentCodec(), new JavaScriptCodec(), new VBScriptCodec(), new CSSCodec(), new MySQLCodec(), new OracleCodec(), new XMLEntityCodec(), new UnixCodec(), new WindowsCodec()));

    public static String getMd5HexString(InputStream data) {
        try {
            return DigestUtils.md5Hex((InputStream)data);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6Md5\u7f16\u7801\u65f6IOException\u5f02\u5e38");
            return null;
        }
    }

    public static String getSha1HexString(InputStream data) {
        try {
            return DigestUtils.sha1Hex((InputStream)data);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6Sha1\u7f16\u7801\u65f6IOException\u5f02\u5e38");
            return null;
        }
    }

    public static ByteArrayInputStream stringToInputStream(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public static HttpInputMessage createHttpInputMessage(final HttpHeaders httpHeaders, String data) {
        final byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new HttpInputMessage(){

            public HttpHeaders getHeaders() {
                httpHeaders.setContentLength((long)bytes.length);
                return httpHeaders;
            }

            public InputStream getBody() {
                return inputStream;
            }
        };
    }

    public static String canonicalize(String input) {
        return CodecUtils.canonicalize(input, true);
    }

    public static String canonicalize(String input, boolean strict) {
        return CodecUtils.canonicalize(input, strict, strict);
    }

    public static String canonicalize(String input, boolean throwEnable, boolean logEnable) {
        return encoder.canonicalize(input, throwEnable, logEnable);
    }

    public static String[] canonicalize(String[] inputArray) {
        return CodecUtils.canonicalize(inputArray, true);
    }

    public static String[] canonicalize(String[] inputArray, boolean strict) {
        return CodecUtils.canonicalize(inputArray, strict, strict);
    }

    public static String[] canonicalize(String[] inputArray, boolean throwEnable, boolean logEnable) {
        String[] outputArray = null;
        if (inputArray != null) {
            outputArray = new String[inputArray.length];
            for (int i = 0; i < inputArray.length; ++i) {
                outputArray[i] = StringUtils.isNotEmpty((CharSequence)inputArray[i]) ? encoder.canonicalize(inputArray[i], throwEnable, logEnable) : inputArray[i];
            }
        }
        return outputArray;
    }
}

