/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.utils;

import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.utils.IOUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.StreamUtils;

public class BaseCodeUtils {
    protected static LoggerHandle logger = new LoggerHandle(BaseCodeUtils.class);
    public static final String CHARSET = "UTF-8";
    public static final String IAMGE_FORMAT = "png";

    public static ByteArrayInputStream convertBase64ToImage(String imageBase64) {
        if (StringUtils.startsWith((CharSequence)imageBase64, (CharSequence)"data:")) {
            imageBase64 = StringUtils.substringAfterLast((String)imageBase64, (String)";base64,");
            imageBase64 = RegExUtils.replacePattern((String)imageBase64, (String)"\r\n", (String)"");
            imageBase64 = StringUtils.replace((String)imageBase64, (String)" ", (String)"").trim();
        }
        byte[] bytes = Base64.decodeBase64((String)imageBase64);
        return new ByteArrayInputStream(bytes);
    }

    public static String convertImageToBase64(ByteArrayInputStream inputStream) {
        try {
            String string = Base64.encodeBase64String((byte[])StreamUtils.copyToByteArray((InputStream)inputStream));
            return string;
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    public static String convertImageToBase64(BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, IAMGE_FORMAT, baos);
        }
        catch (IOException e) {
            logger.error(e);
            return null;
        }
        byte[] bytes = baos.toByteArray();
        IOUtils.closeQuietly((OutputStream)baos);
        return Base64.encodeBase64String((byte[])bytes);
    }
}

